/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.dialog.AbstractDatabaseConnectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DatabaseConnectionsPanel
extends BasePanel {
    private static final long serialVersionUID = -4151139612136850913L;
    protected BaseTabbedPane m_TabbedPane;
    protected HashSet<ChangeListener> m_ChangeListeners;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ChangeListeners = new HashSet();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        String[] classes = AbstractDatabaseConnectionPanel.getPanels();
        Vector<AbstractDatabaseConnectionPanel> panels = new Vector<AbstractDatabaseConnectionPanel>();
        for (String cls : classes) {
            try {
                AbstractDatabaseConnectionPanel panel = (AbstractDatabaseConnectionPanel)Class.forName(cls).newInstance();
                panel.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        DatabaseConnectionsPanel.this.notifyChangeListeners();
                    }
                });
                panels.add(panel);
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate '" + cls + "':");
                e.printStackTrace();
            }
        }
        Collections.sort(panels);
        for (AbstractDatabaseConnectionPanel pnl : panels) {
            this.m_TabbedPane.addTab(pnl.getTitle(), pnl);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(event);
        }
    }
}

