/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractAxisModel;

public class Log10AbsoluteAxisModel
extends AbstractAxisModel {
    private static final long serialVersionUID = -8786821788014926817L;

    @Override
    public boolean canHandle(double min, double max) {
        return min > 0.0 && max > 0.0;
    }

    @Override
    public String getDisplayName() {
        return "Log10 absolute";
    }

    @Override
    public String valueToDisplay(double value) {
        return this.getActualFormatter().format(value);
    }

    @Override
    public double displayToValue(String display) {
        return this.getActualFormatter().parse(display);
    }

    @Override
    public int valueToPos(double value) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        double tmp = Math.log10(value) - Math.log10(this.m_ActualMinimum);
        tmp /= Math.log10(this.m_ActualMaximum) - Math.log10(this.m_ActualMinimum);
        int result = (int)Math.round(tmp *= (double)size);
        return result;
    }

    @Override
    public double posToValue(int pos) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        double tmp = (double)pos / (double)size;
        tmp *= Math.log10(this.m_ActualMaximum) - Math.log10(this.m_ActualMinimum);
        tmp += Math.log10(this.m_ActualMinimum);
        double result = tmp = Math.pow(10.0, tmp);
        return result;
    }
}

