/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractAxisModel;
import adams.gui.visualization.core.axis.FlippableAxisModel;

public class PercentageAxisModel
extends AbstractAxisModel
implements FlippableAxisModel {
    private static final long serialVersionUID = 6882846237550109166L;
    protected boolean m_Flipped;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Flipped = false;
    }

    @Override
    public boolean canHandle(double min, double max) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Percent";
    }

    @Override
    public String getDefaultNumberFormat() {
        return "0.0'%';-0.0'%'";
    }

    @Override
    public void setFlipped(boolean value) {
        this.m_Flipped = value;
        this.invalidate();
        this.update();
    }

    @Override
    public boolean isFlipped() {
        return this.m_Flipped;
    }

    @Override
    public String valueToDisplay(double value) {
        String result;
        if (Double.isNaN(value)) {
            result = this.getActualFormatter().format(value);
        } else {
            double raw = (value - this.m_Minimum) / (this.m_Maximum - this.m_Minimum) * 100.0;
            result = this.getActualFormatter().format(raw);
        }
        return result;
    }

    @Override
    public double displayToValue(String display) {
        Double result = this.getActualFormatter().parse(display);
        if (!result.isNaN()) {
            result = result / 100.0;
            result = result * (this.m_Maximum - this.m_Minimum);
            result = result + this.m_Minimum;
        }
        return result;
    }

    @Override
    public int valueToPos(double value) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        int result = (int)Math.round((value - this.m_ActualMinimum) / (this.m_ActualMaximum - this.m_ActualMinimum) * (double)size);
        if (this.m_Flipped) {
            result = this.getParent().getLength() - 1 - result;
        }
        return result;
    }

    @Override
    public double posToValue(int pos) {
        this.validate();
        if (this.m_Flipped) {
            pos = this.getParent().getLength() - 1 - pos;
        }
        int size = this.getParent().getLength() - 1;
        double result = (double)pos / (double)size * (this.m_ActualMaximum - this.m_ActualMinimum) + this.m_ActualMinimum;
        return result;
    }
}

