/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.geometry;

import de.intarsys.tools.geometry.TransformedShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;

public class ApplySpaceChangeShape
extends TransformedShape {
    private final AffineTransform sourceTransform;
    private final AffineTransform targetTransform;

    public static TransformedShape create(Shape shape, AffineTransform transform) {
        ApplySpaceChangeShape ascShape;
        if (shape instanceof ApplySpaceChangeShape && (ascShape = (ApplySpaceChangeShape)shape).getTargetTransform().equals(transform)) {
            return ApplySpaceChangeShape.create(ascShape.getBaseShape(), ascShape.getSourceTransform(), transform);
        }
        return ApplySpaceChangeShape.create(shape, (AffineTransform)transform.clone(), transform);
    }

    public static TransformedShape create(Shape shape, AffineTransform sourceTransform, AffineTransform targetTransform) {
        return new ApplySpaceChangeShape(shape, sourceTransform, targetTransform);
    }

    public static TransformedShape setTransform(Shape shape, AffineTransform targetTransform) {
        if (shape instanceof ApplySpaceChangeShape) {
            ApplySpaceChangeShape ts = (ApplySpaceChangeShape)shape;
            return new ApplySpaceChangeShape(ts.getBaseShape(), ts.getSourceTransform(), targetTransform);
        }
        return new ApplySpaceChangeShape(shape, IDENTITY, targetTransform);
    }

    protected ApplySpaceChangeShape(ApplySpaceChangeShape shape) {
        super(shape);
        this.sourceTransform = shape.sourceTransform;
        this.targetTransform = (AffineTransform)shape.targetTransform.clone();
    }

    protected ApplySpaceChangeShape(Shape shape, AffineTransform sourceTransform, AffineTransform targetTransform) {
        super(shape);
        this.sourceTransform = sourceTransform;
        this.targetTransform = targetTransform;
    }

    protected Shape apply() {
        if (this.targetTransform.equals(this.sourceTransform)) {
            return this.getBaseShape();
        }
        if (this.getBaseShape() instanceof Area) {
            return new Area(this.getTransform().createTransformedShape(this.getBaseShape()));
        }
        return this.getTransform().createTransformedShape(this.getBaseShape());
    }

    public Object clone() {
        return new ApplySpaceChangeShape(this);
    }

    public AffineTransform getSourceTransform() {
        return this.sourceTransform;
    }

    public AffineTransform getTargetTransform() {
        return this.targetTransform;
    }

    public AffineTransform getTransform() {
        try {
            if (this.targetTransform.equals(this.sourceTransform)) {
                return new AffineTransform();
            }
            AffineTransform tempTransform = this.targetTransform.createInverse();
            tempTransform.concatenate(this.sourceTransform);
            return tempTransform;
        }
        catch (NoninvertibleTransformException e) {
            return new AffineTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }
}

