/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.locator.AbstractLocatorLookup;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingLocatorLookup
extends AbstractLocatorLookup {
    private List<ILocatorFactory> factories = new ArrayList<ILocatorFactory>();

    public boolean addLocatorFactory(ILocatorFactory factory) {
        if (factory == this) {
            throw new IllegalArgumentException("can not delegate to myself");
        }
        return this.factories.add(factory);
    }

    @Override
    public ILocator createLocator(String location) throws IOException {
        for (ILocatorFactory factory : this.factories) {
            try {
                return factory.createLocator(location);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw ExceptionTools.createIOException("", e);
            }
        }
        throw new FileNotFoundException(location);
    }

    public void clear() {
        this.factories.clear();
    }

    public List<ILocatorFactory> getLocatorFactories() {
        return new ArrayList<ILocatorFactory>(this.factories);
    }

    public boolean removeLocatorFactory(ILocatorFactory factory) {
        return this.factories.remove(factory);
    }
}

