/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.PlaceholderFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class Bzip2Utils {
    public static final String EXTENSION = ".bz2";

    public static String decompress(File archiveFile, int buffer) {
        return Bzip2Utils.decompress(archiveFile, buffer, (File)new PlaceholderFile(archiveFile.getAbsolutePath().replaceAll("\\.gz$", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(File archiveFile, int buffer, File outputFile) {
        BZip2CompressorInputStream in = null;
        FilterOutputStream out = null;
        String result = null;
        try {
            int len;
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            byte[] buf = new byte[buffer];
            in = new BZip2CompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(archiveFile.getAbsolutePath())));
            out = new BufferedOutputStream(new FileOutputStream(outputFile), buffer);
            while ((len = in.read(buf)) > 0) {
                ((BufferedOutputStream)out).write(buf, 0, len);
            }
            in.close();
            in = null;
            out.close();
            out = null;
        }
        catch (Exception e) {
            String msg = "Failed to decompress '" + archiveFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static String compress(File inputFile, int buffer) {
        return Bzip2Utils.compress(inputFile, buffer, (File)new PlaceholderFile(inputFile.getAbsolutePath() + EXTENSION));
    }

    public static String compress(File inputFile, int buffer, File outputFile) {
        return Bzip2Utils.compress(inputFile, buffer, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compress(File inputFile, int buffer, File outputFile, boolean removeInput) {
        BufferedInputStream in = null;
        BZip2CompressorOutputStream out = null;
        String result = null;
        try {
            int len;
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            byte[] buf = new byte[buffer];
            out = new BZip2CompressorOutputStream((OutputStream)new FileOutputStream(outputFile));
            in = new BufferedInputStream(new FileInputStream(inputFile.getAbsolutePath()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            in = null;
            out.close();
            out = null;
            if (removeInput && !inputFile.delete()) {
                result = "Failed to delete input file '" + inputFile + "' after successful compression!";
            }
        }
        catch (Exception e) {
            String msg = "Failed to compress '" + inputFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

