/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.Vector;

public abstract class AbstractMultiDecompress
extends AbstractTransformer {
    private static final long serialVersionUID = 4547786117935917444L;
    protected PlaceholderDirectory m_OutputDir;
    protected BaseRegExp m_RegExp;
    protected boolean m_InvertMatching;
    protected boolean m_CreateDirectories;
    protected int m_BufferSize;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("out-dir", "outputDir", (Object)new PlaceholderDirectory("."));
        this.m_OptionManager.add("reg-exp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invertMatching", (Object)false);
        this.m_OptionManager.add("create-dirs", "createDirectories", (Object)false);
        this.m_OptionManager.add("buffer", "bufferSize", (Object)1024);
    }

    public void setOutputDir(PlaceholderDirectory value) {
        this.m_OutputDir = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDir() {
        return this.m_OutputDir;
    }

    public String outputDirTipText() {
        return "The output directory to use.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the file names must match in order to be extracted.";
    }

    public void setInvertMatching(boolean value) {
        this.m_InvertMatching = value;
        this.reset();
    }

    public boolean getInvertMatching() {
        return this.m_InvertMatching;
    }

    public String invertMatchingTipText() {
        return "If set to true, the matching sense of the regular expression is inverted.";
    }

    public void setCreateDirectories(boolean value) {
        this.m_CreateDirectories = value;
        this.reset();
    }

    public boolean getCreateDirectories() {
        return this.m_CreateDirectories;
    }

    public String createDirectoriesTipText() {
        return "If set to true, the directory structure stored in the archive will be restored.";
    }

    public void setBufferSize(int value) {
        this.m_BufferSize = value;
        this.reset();
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    public String bufferSizeTipText() {
        return "The size of the buffer in bytes for the data stream.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("outputDir");
        String result = variable != null ? variable : (this.m_OutputDir != null ? this.m_OutputDir.toString() : "");
        variable = this.getOptionManager().getVariableForProperty("regExp");
        if (variable != null) {
            result = result + ", " + variable;
        } else if (!this.m_RegExp.equals((Object)".*")) {
            result = result + ", " + this.m_RegExp;
        }
        if (this.m_InvertMatching) {
            result = result + ", inverted";
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String[].class};
    }

    protected abstract Vector<File> decompress(File var1, StringBuilder var2);

    protected String doExecute() {
        StringBuilder result = new StringBuilder();
        File inFile = null;
        if (this.m_InputToken.getPayload() instanceof File) {
            inFile = (File)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof String) {
            inFile = new PlaceholderFile((String)this.m_InputToken.getPayload());
        }
        Vector<File> output = this.decompress(inFile, result);
        if (output.size() > 0) {
            String[] files = new String[output.size()];
            for (int i = 0; i < output.size(); ++i) {
                files[i] = output.get(i).getAbsolutePath();
            }
            this.m_OutputToken = new Token((Object)files);
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }
}

