/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.TimesScalarCalculation;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimesScalarSparseMatrix
implements TimesScalarCalculation<SparseMatrix, SparseMatrix> {
    TimesScalarSparseMatrix() {
    }

    @Override
    public final void calc(SparseMatrix source, BigDecimal factor, SparseMatrix target) {
        VerifyUtil.assertSameSize((Matrix)source, (Matrix)target);
        for (long[] c : source.availableCoordinates()) {
            BigDecimal value = source.getAsBigDecimal(c);
            BigDecimal result = MathUtil.times(value, factor);
            target.setAsBigDecimal(result, c);
        }
    }

    @Override
    public final void calc(SparseMatrix source, double factor, SparseMatrix target) {
        this.calc(source, new BigDecimal(factor, MathUtil.getDefaultMathContext()), target);
    }
}

