/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Chol;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Solve;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SolveSPD<T>
extends Solve<T> {
    public static final int SQUARETHRESHOLD = 100;
    public static final SolveSPD<Matrix> MATRIX = new SolveSPD<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                    return MATRIXSQUARELARGESINGLETHREADED.calc(a, b);
                }
                return MATRIXSQUARESMALLSINGLETHREADED.calc(a, b);
            }
            if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                return MATRIXSQUARELARGEMULTITHREADED.calc(a, b);
            }
            return MATRIXSQUARESMALLMULTITHREADED.calc(a, b);
        }
    };
    public static final SolveSPD<Matrix> INSTANCE = MATRIX;
    public static final SolveSPD<Matrix> UJMPSQUARE = new SolveSPD<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            return Chol.INSTANCE.solve(a, b);
        }
    };
    public static final SolveSPD<Matrix> MATRIXSQUARESMALLSINGLETHREADED = UJMPSQUARE;
    public static final SolveSPD<Matrix> MATRIXSQUARELARGESINGLETHREADED = new SolveSPD<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            SolveSPD solve = null;
            if (UJMPSettings.isUseJBlas()) {
                solve = DecompositionOps.SOLVESPD_JBLAS;
            }
            if (solve == null && UJMPSettings.isUseOjalgo()) {
                solve = DecompositionOps.SOLVESPD_OJALGO;
            }
            if (solve == null && UJMPSettings.isUseEJML()) {
                solve = DecompositionOps.SOLVESPD_EJML;
            }
            if (solve == null && UJMPSettings.isUseMTJ()) {
                solve = DecompositionOps.SOLVESPD_MTJ;
            }
            if (solve == null) {
                solve = UJMPSQUARE;
            }
            return solve.calc(a, b);
        }
    };
    public static final SolveSPD<Matrix> MATRIXSQUARELARGEMULTITHREADED = new SolveSPD<Matrix>(){

        @Override
        public Matrix calc(Matrix a, Matrix b) {
            SolveSPD solve = null;
            if (UJMPSettings.isUseJBlas()) {
                solve = DecompositionOps.SOLVESPD_JBLAS;
            }
            if (solve == null && UJMPSettings.isUseOjalgo()) {
                solve = DecompositionOps.SOLVESPD_OJALGO;
            }
            if (solve == null && UJMPSettings.isUseEJML()) {
                solve = DecompositionOps.SOLVESPD_EJML;
            }
            if (solve == null) {
                solve = UJMPSQUARE;
            }
            return solve.calc(a, b);
        }
    };
    public static final SolveSPD<Matrix> MATRIXSQUARESMALLMULTITHREADED = UJMPSQUARE;

    @Override
    public T calc(T var1, T var2);
}

