/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.ejml;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ejml.alg.dense.decomposition.CholeskyDecomposition;
import org.ejml.alg.dense.decomposition.DecompositionFactory;
import org.ejml.alg.dense.decomposition.EigenDecomposition;
import org.ejml.alg.dense.decomposition.LUDecomposition;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.ejml.calculation.Inv;
import org.ujmp.ejml.calculation.InvSPD;
import org.ujmp.ejml.calculation.QR;
import org.ujmp.ejml.calculation.SVD;
import org.ujmp.ejml.calculation.Solve;

public class EJMLDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DenseMatrix64F>,
HasRowMajorDoubleArray1D {
    private static final long serialVersionUID = -3223474248020842822L;
    private transient DenseMatrix64F matrix;

    public EJMLDenseDoubleMatrix2D(long ... size) {
        this.matrix = new DenseMatrix64F((int)size[0], (int)size[1]);
    }

    public EJMLDenseDoubleMatrix2D(DenseMatrix64F m) {
        this.matrix = m;
    }

    public EJMLDenseDoubleMatrix2D(Matrix source) throws MatrixException {
        if (source instanceof HasRowMajorDoubleArray2D) {
            double[][] data = ((HasRowMajorDoubleArray2D)((Object)source)).getRowMajorDoubleArray2D();
            this.matrix = new DenseMatrix64F(data);
        } else if (source instanceof DenseDoubleMatrix2D) {
            this.matrix = new DenseMatrix64F((int)source.getRowCount(), (int)source.getColumnCount());
            DenseDoubleMatrix2D m2 = (DenseDoubleMatrix2D)source;
            int r = (int)source.getRowCount();
            while (--r >= 0) {
                int c = (int)source.getColumnCount();
                while (--c >= 0) {
                    this.matrix.set(r, c, m2.getDouble(r, c));
                }
            }
        } else {
            this.matrix = new DenseMatrix64F((int)source.getRowCount(), (int)source.getColumnCount());
            for (long[] c : source.availableCoordinates()) {
                this.setDouble(source.getAsDouble(c), c);
            }
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.get((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.get(row, column);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.numRows, this.matrix.numCols};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.set((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.set(row, column, value);
    }

    @Override
    public DenseMatrix64F getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(DenseMatrix64F object) {
        this.matrix = object;
    }

    @Override
    public Matrix transpose() {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numCols, this.matrix.numRows);
        CommonOps.transpose((DenseMatrix64F)this.matrix, (DenseMatrix64F)ret);
        return new EJMLDenseDoubleMatrix2D(ret);
    }

    @Override
    public Matrix inv() {
        return Inv.INSTANCE.calc(this);
    }

    @Override
    public Matrix invSPD() {
        return InvSPD.INSTANCE.calc(this);
    }

    @Override
    public double det() {
        return CommonOps.det((DenseMatrix64F)this.matrix);
    }

    @Override
    public Matrix solve(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix plus(double value) {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
        CommonOps.add((DenseMatrix64F)this.matrix, (double)value, (DenseMatrix64F)ret);
        return new EJMLDenseDoubleMatrix2D(ret);
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof EJMLDenseDoubleMatrix2D) {
            DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
            CommonOps.add((DenseMatrix64F)this.matrix, (DenseMatrix64F)((EJMLDenseDoubleMatrix2D)m).matrix, (DenseMatrix64F)ret);
            return new EJMLDenseDoubleMatrix2D(ret);
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof EJMLDenseDoubleMatrix2D) {
            DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
            CommonOps.sub((DenseMatrix64F)this.matrix, (DenseMatrix64F)((EJMLDenseDoubleMatrix2D)m).matrix, (DenseMatrix64F)ret);
            return new EJMLDenseDoubleMatrix2D(ret);
        }
        return super.minus(m);
    }

    @Override
    public Matrix minus(double value) {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
        CommonOps.add((DenseMatrix64F)this.matrix, (double)(-value), (DenseMatrix64F)ret);
        return new EJMLDenseDoubleMatrix2D(ret);
    }

    @Override
    public Matrix times(double value) {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
        CommonOps.scale((double)value, (DenseMatrix64F)this.matrix, (DenseMatrix64F)ret);
        return new EJMLDenseDoubleMatrix2D(ret);
    }

    @Override
    public Matrix divide(double value) {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
        CommonOps.scale((double)(1.0 / value), (DenseMatrix64F)this.matrix, (DenseMatrix64F)ret);
        return new EJMLDenseDoubleMatrix2D(ret);
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof EJMLDenseDoubleMatrix2D) {
            DenseMatrix64F b = ((EJMLDenseDoubleMatrix2D)m).getWrappedObject();
            DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, b.numCols);
            CommonOps.mult((DenseMatrix64F)this.matrix, (DenseMatrix64F)b, (DenseMatrix64F)ret);
            return new EJMLDenseDoubleMatrix2D(ret);
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix[] svd() {
        return SVD.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] qr() {
        return QR.INSTANCE.calc(this);
    }

    @Override
    public Matrix chol() {
        CholeskyDecomposition chol = DecompositionFactory.chol();
        chol.decompose(this.matrix);
        EJMLDenseDoubleMatrix2D l = new EJMLDenseDoubleMatrix2D(chol.getT(null));
        return l;
    }

    @Override
    public Matrix[] lu() {
        if (this.isSquare()) {
            LUDecomposition lu = DecompositionFactory.lu();
            lu.decompose(this.matrix);
            DenseMatrix64F lm = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
            DenseMatrix64F um = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
            lu.getLower(lm);
            lu.getUpper(um);
            EJMLDenseDoubleMatrix2D l = new EJMLDenseDoubleMatrix2D(lm);
            EJMLDenseDoubleMatrix2D u = new EJMLDenseDoubleMatrix2D(um);
            EJMLDenseDoubleMatrix2D p = new EJMLDenseDoubleMatrix2D(lu.getPivot(null));
            return new Matrix[]{l, u, p};
        }
        return super.lu();
    }

    @Override
    public Matrix[] eig() {
        EigenDecomposition eig = DecompositionFactory.eig();
        eig.decompose(this.matrix);
        int N = this.matrix.numRows;
        DenseMatrix64F D = new DenseMatrix64F(N, N);
        DenseMatrix64F V = new DenseMatrix64F(N, N);
        int i = 0;
        while (i < N) {
            Complex64F c = eig.getEigenvalue(i);
            if (c.isReal()) {
                D.set(i, i, c.real);
                DenseMatrix64F v = eig.getEigenVector(i);
                if (v != null) {
                    int j = 0;
                    while (j < N) {
                        V.set(j, i, v.get(j, 0));
                        ++j;
                    }
                }
            }
            ++i;
        }
        EJMLDenseDoubleMatrix2D v = new EJMLDenseDoubleMatrix2D(V);
        EJMLDenseDoubleMatrix2D d = new EJMLDenseDoubleMatrix2D(D);
        return new Matrix[]{v, d};
    }

    @Override
    public Matrix copy() {
        EJMLDenseDoubleMatrix2D m = new EJMLDenseDoubleMatrix2D(this.matrix.copy());
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int rows = (Integer)s.readObject();
        int columns = (Integer)s.readObject();
        double[] values = (double[])s.readObject();
        this.matrix = new DenseMatrix64F(rows, columns, true, values);
    }

    private void writeObject(ObjectOutputStream s) throws IOException, MatrixException {
        s.defaultWriteObject();
        s.writeObject(this.matrix.numRows);
        s.writeObject(this.matrix.numCols);
        s.writeObject(this.matrix.data);
    }

    @Override
    public double[] getRowMajorDoubleArray1D() {
        return this.matrix.getData();
    }
}

