/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.util;

import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FastListSelectionModel
implements ListSelectionModel {
    private final int selectionMode = 1;
    private int minIndex = -1;
    private int maxIndex = -1;
    private boolean valueIsAdjusting = false;
    protected EventListenerList listenerList = new EventListenerList();

    public void addListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(ListSelectionListener.class, l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.remove(ListSelectionListener.class, l);
    }

    public void addSelectionInterval(int index0, int index1) {
        if (index1 > index0) {
            this.minIndex = Math.min(this.minIndex, index0);
            this.maxIndex = Math.max(this.maxIndex, index1);
        } else {
            this.minIndex = Math.min(this.minIndex, index1);
            this.maxIndex = Math.max(this.maxIndex, index0);
        }
        this.fireValueChanged();
    }

    protected void fireValueChanged(int firstIndex, int lastIndex) {
        this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ListSelectionListener.class) {
                if (e == null) {
                    e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
                }
                ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
            }
            i -= 2;
        }
    }

    public void clearSelection() {
        this.minIndex = -1;
        this.maxIndex = -1;
        this.fireValueChanged();
    }

    private void fireValueChanged() {
        this.fireValueChanged(0, Integer.MAX_VALUE);
    }

    public int getMinSelectionIndex() {
        return this.minIndex;
    }

    public int getAnchorSelectionIndex() {
        return this.minIndex;
    }

    public int getLeadSelectionIndex() {
        return this.maxIndex;
    }

    public int getMaxSelectionIndex() {
        return this.maxIndex;
    }

    public int getSelectionMode() {
        return 1;
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        this.minIndex = Math.min(this.minIndex, index);
        this.maxIndex = Math.max(this.maxIndex, index + length);
        this.fireValueChanged();
    }

    public boolean isSelectedIndex(int index) {
        return index >= this.minIndex && index <= this.maxIndex;
    }

    public boolean isSelectionEmpty() {
        return this.minIndex == -1 || this.maxIndex == -1;
    }

    public void removeIndexInterval(int index0, int index1) {
        if (index1 >= index0) {
            this.minIndex = Math.max(this.minIndex, index0);
            this.maxIndex = Math.min(this.maxIndex, index1);
        } else {
            this.minIndex = Math.max(this.minIndex, index1);
            this.maxIndex = Math.min(this.maxIndex, index0);
        }
        this.fireValueChanged();
    }

    public void removeSelectionInterval(int index0, int index1) {
        if (index1 >= index0) {
            this.minIndex = Math.max(this.minIndex, index0);
            this.maxIndex = Math.min(this.maxIndex, index1);
        } else {
            this.minIndex = Math.max(this.minIndex, index1);
            this.maxIndex = Math.min(this.maxIndex, index0);
        }
        this.fireValueChanged();
    }

    public void setAnchorSelectionIndex(int index) {
        this.minIndex = Math.min(this.minIndex, index);
        this.fireValueChanged();
    }

    public void setLeadSelectionIndex(int index) {
        this.maxIndex = Math.max(this.maxIndex, index);
        this.fireValueChanged();
    }

    public void setSelectionInterval(int index0, int index1) {
        if (index1 > index0) {
            this.minIndex = index0;
            this.maxIndex = index1;
        } else {
            this.minIndex = index1;
            this.maxIndex = index0;
        }
        this.fireValueChanged();
    }

    public void setSelectionMode(int selectionMode) {
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }
}

