/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.sst;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.util.MathUtil;
import shared.array.AbstractRealArray;
import shared.array.RealArray;

public class SSTDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<RealArray> {
    private static final long serialVersionUID = -9002457298955206969L;
    private transient RealArray data = null;

    public SSTDenseDoubleMatrix2D(RealArray data) {
        this.data = data;
    }

    public SSTDenseDoubleMatrix2D(long ... size) {
        this.data = new RealArray(MathUtil.toIntArray(size));
    }

    public SSTDenseDoubleMatrix2D(Matrix source) {
        this.data = new RealArray(MathUtil.toIntArray(source.getSize()));
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long rows, long columns) throws MatrixException {
        return this.data.get(new int[]{(int)rows, (int)columns});
    }

    @Override
    public double getDouble(int rows, int columns) throws MatrixException {
        return this.data.get(new int[]{rows, columns});
    }

    @Override
    public void setDouble(double value, long rows, long columns) throws MatrixException {
        this.data.set(value, new int[]{(int)rows, (int)columns});
    }

    @Override
    public void setDouble(double value, int rows, int columns) throws MatrixException {
        this.data.set(value, new int[]{rows, columns});
    }

    @Override
    public long[] getSize() {
        return MathUtil.toLongArray(this.data.dimensions());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        byte[] bytes = (byte[])s.readObject();
        this.data = RealArray.parse((byte[])bytes);
    }

    private void writeObject(ObjectOutputStream s) throws IOException, MatrixException {
        s.defaultWriteObject();
        s.writeObject(this.data.getBytes());
    }

    @Override
    public RealArray getWrappedObject() {
        return this.data;
    }

    @Override
    public void setWrappedObject(RealArray object) {
        this.data = object;
    }

    @Override
    public Matrix transpose() {
        return new SSTDenseDoubleMatrix2D(this.data.mTranspose());
    }

    @Override
    public Matrix inv() {
        return new SSTDenseDoubleMatrix2D(this.data.mInvert());
    }

    @Override
    public Matrix[] eig() {
        RealArray[] eig = this.data.mEigs();
        SSTDenseDoubleMatrix2D v = new SSTDenseDoubleMatrix2D(eig[0]);
        SSTDenseDoubleMatrix2D d = new SSTDenseDoubleMatrix2D(eig[1]);
        return new Matrix[]{v, d};
    }

    @Override
    public Matrix[] svd() {
        RealArray[] svd = this.data.mSVD();
        SSTDenseDoubleMatrix2D u = new SSTDenseDoubleMatrix2D(svd[0]);
        SSTDenseDoubleMatrix2D s = new SSTDenseDoubleMatrix2D(svd[1]);
        SSTDenseDoubleMatrix2D v = new SSTDenseDoubleMatrix2D(svd[2]);
        return new Matrix[]{u, s, v};
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof SSTDenseDoubleMatrix2D) {
            return new SSTDenseDoubleMatrix2D(this.data.mMul(((SSTDenseDoubleMatrix2D)m).getWrappedObject()));
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix plus(double v) {
        return new SSTDenseDoubleMatrix2D((RealArray)((RealArray)this.data.clone()).uAdd(v));
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof SSTDenseDoubleMatrix2D) {
            return new SSTDenseDoubleMatrix2D((RealArray)((RealArray)this.data.clone()).eAdd((AbstractRealArray)((SSTDenseDoubleMatrix2D)m).getWrappedObject()));
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof SSTDenseDoubleMatrix2D) {
            return new SSTDenseDoubleMatrix2D((RealArray)((RealArray)this.data.clone()).eSub((AbstractRealArray)((SSTDenseDoubleMatrix2D)m).getWrappedObject()));
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(double v) {
        return new SSTDenseDoubleMatrix2D((RealArray)((RealArray)this.data.clone()).uAdd(-v));
    }

    @Override
    public Matrix times(double v) {
        return new SSTDenseDoubleMatrix2D((RealArray)((RealArray)this.data.clone()).uMul(v));
    }

    @Override
    public Matrix divide(double v) {
        return new SSTDenseDoubleMatrix2D((RealArray)((RealArray)this.data.clone()).uMul(1.0 / v));
    }
}

