/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.evaluator;

import adams.data.weka.evaluator.AbstractDatasetInstanceEvaluator;
import java.util.Random;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;

public abstract class AbstractCrossvalidatedInstanceEvaluator<T extends EvaluationContainer>
extends AbstractDatasetInstanceEvaluator {
    private static final long serialVersionUID = 5958214723994891350L;
    protected int m_Folds;
    protected int m_Seed;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("folds", "folds", (Object)2);
        this.m_OptionManager.add("seed", "seed", (Object)1);
    }

    public void setFolds(int value) {
        this.m_Folds = value;
        this.reset();
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use for cross-validation; cross-validation gets turned off below a value of 2.";
    }

    public void setSeed(int value) {
        this.m_Seed = value;
        this.reset();
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for randomizing the data for cross-validation.";
    }

    protected abstract String findThreshold(Vector<T> var1);

    protected abstract Vector<T> evaluate(Instances var1, Instances var2);

    @Override
    protected String findThreshold() {
        String result = null;
        Random rand = new Random(this.m_Seed);
        Instances data = new Instances(this.m_Data);
        data.randomize(rand);
        Vector<T> evals = new Vector<T>();
        if (this.m_Folds < 2) {
            evals.addAll(this.evaluate(data, data));
        } else {
            if (data.classAttribute().isNominal()) {
                data.stratify(this.m_Folds);
            }
            for (int i = 0; i < this.m_Folds; ++i) {
                Instances train = data.trainCV(this.m_Folds, i, rand);
                Instances test = data.testCV(this.m_Folds, i);
                evals.addAll(this.evaluate(train, test));
            }
        }
        result = this.findThreshold(evals);
        return result;
    }

    public static abstract class EvaluationContainer
    implements Comparable {
        protected Instance m_Instance;

        public EvaluationContainer(Instance inst) {
            this.m_Instance = inst;
        }

        public Instance getInstance() {
            return this.m_Instance;
        }

        public abstract int compareTo(Object var1);

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public abstract String toString();
    }
}

