/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.SingleIndex;

public class SingleIndexTest
extends TestCase {
    public SingleIndexTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected SingleIndex getIndex(String initial, int upper) {
        SingleIndex result;
        if (initial == null) {
            result = new SingleIndex();
            result.setSingleIndex("1");
            result.setUpper(upper);
        } else {
            result = new SingleIndex(initial);
            result.setUpper(upper);
        }
        return result;
    }

    public void testDefaultConstructor() throws Exception {
        int upper = 10;
        int indexInt = 0;
        String indexStr = "" + (indexInt + 1);
        SingleIndex index = new SingleIndex();
        index.setSingleIndex(indexStr);
        index.setUpper(upper);
        SingleIndexTest.assertEquals((String)indexStr, (String)index.getSingleIndex());
        SingleIndexTest.assertEquals((int)indexInt, (int)index.getIndex());
    }

    public void testInitialValueConstructor() throws Exception {
        int upper = 10;
        int indexInt = 0;
        String indexStr = "" + (indexInt + 1);
        SingleIndex index = this.getIndex("1", upper);
        SingleIndexTest.assertEquals((String)indexStr, (String)index.getSingleIndex());
        SingleIndexTest.assertEquals((int)indexInt, (int)index.getIndex());
    }

    public void testFirst() throws Exception {
        int upper = 10;
        SingleIndex index = this.getIndex("first", upper);
        SingleIndexTest.assertEquals((int)0, (int)index.getIndex());
        SingleIndexTest.assertEquals((String)"first", (String)index.getSingleIndex());
    }

    public void testLast() throws Exception {
        int upper = 10;
        SingleIndex index = this.getIndex("last", upper);
        SingleIndexTest.assertEquals((int)upper, (int)index.getIndex());
        SingleIndexTest.assertEquals((String)"last", (String)index.getSingleIndex());
    }

    public static Test suite() {
        return new TestSuite(SingleIndexTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SingleIndexTest.suite());
    }
}

