/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.ConsoleObject;
import adams.core.DebugOutputHandler;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderDirectory;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.Vector;

public class DirectoryLister
extends ConsoleObject
implements DebugOutputHandler {
    private static final long serialVersionUID = -1846677500660003814L;
    protected boolean m_Debug;
    protected PlaceholderDirectory m_WatchDir = new PlaceholderDirectory(".");
    protected boolean m_ListDirs = false;
    protected boolean m_ListFiles = true;
    protected Sorting m_Sorting = Sorting.NO_SORTING;
    protected boolean m_SortDescending = false;
    protected int m_MaxItems = -1;
    protected BaseRegExp m_RegExp = new BaseRegExp("");
    protected String m_StopFile = "STOP.txt";
    protected boolean m_StopFileEncountered = false;
    protected boolean m_Stopped = false;
    protected boolean m_Recursive = false;
    protected int m_MaxDepth = -1;
    protected DebugOutputHandler m_DebugOutputHandler = null;
    protected boolean m_SkipLockedFiles = false;
    protected BaseDateTime m_MinFileTimestamp = new BaseDateTime("-INF");
    protected BaseDateTime m_MaxFileTimestamp = new BaseDateTime("+INF");

    public void setDebug(boolean value) {
        this.m_Debug = value;
        this.getDebugging().setEnabled(value);
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setWatchDir(PlaceholderDirectory value) {
        this.m_WatchDir = value;
    }

    public PlaceholderDirectory getWatchDir() {
        return this.m_WatchDir;
    }

    public void setListDirs(boolean value) {
        this.m_ListDirs = value;
    }

    public boolean getListDirs() {
        return this.m_ListDirs;
    }

    public void setListFiles(boolean value) {
        this.m_ListFiles = value;
    }

    public boolean getListFiles() {
        return this.m_ListFiles;
    }

    public void setSorting(Sorting value) {
        this.m_Sorting = value;
    }

    public Sorting getSorting() {
        return this.m_Sorting;
    }

    public void setSortDescending(boolean value) {
        this.m_SortDescending = value;
    }

    public boolean getSortDescending() {
        return this.m_SortDescending;
    }

    public void setMaxItems(int value) {
        this.m_MaxItems = value;
    }

    public int getMaxItems() {
        return this.m_MaxItems;
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public void setStopFile(String value) {
        this.m_StopFile = value;
    }

    public String getStopFile() {
        return this.m_StopFile;
    }

    public void setDebugOutputHandler(DebugOutputHandler value) {
        this.m_DebugOutputHandler = value;
    }

    public DebugOutputHandler getDebugOutputHandler() {
        return this.m_DebugOutputHandler;
    }

    public void setRecursive(boolean value) {
        this.m_Recursive = value;
    }

    public boolean getRecursive() {
        return this.m_Recursive;
    }

    public void setMaxDepth(int value) {
        this.m_MaxDepth = value;
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public void setSkipLockedFiles(boolean value) {
        this.m_SkipLockedFiles = value;
    }

    public boolean getSkipLockedFiles() {
        return this.m_SkipLockedFiles;
    }

    public void setMinFileTimestamp(BaseDateTime value) {
        this.m_MinFileTimestamp = value;
    }

    public BaseDateTime getMinFileTimestamp() {
        return this.m_MinFileTimestamp;
    }

    public void setMaxFileTimestamp(BaseDateTime value) {
        this.m_MaxFileTimestamp = value;
    }

    public BaseDateTime getMaxFileTimestamp() {
        return this.m_MaxFileTimestamp;
    }

    public boolean hasStopFileEncountered() {
        return this.m_StopFileEncountered;
    }

    public void stop() {
        this.m_Stopped = true;
    }

    @Override
    public void debug(String msg) {
        if (this.m_Debug) {
            if (this.m_DebugOutputHandler != null) {
                this.m_DebugOutputHandler.debug(msg);
            } else {
                this.getDebugging().println(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isFileLocked(File file) {
        boolean result = false;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, true);
            FileLock fl = fos.getChannel().tryLock();
            if (fl == null) {
                result = true;
            } else {
                fl.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    protected void search(File current, Vector<SortContainer> files, int depth) {
        File[] currFiles;
        if (depth == 0) {
            return;
        }
        if (this.getDebug()) {
            this.debug("search: current=" + current + ", depth=" + depth);
        }
        if ((currFiles = current.listFiles()) == null) {
            this.getSystemErr().println("No files listed!");
            return;
        }
        long minFileAge = this.m_MinFileTimestamp.isInfinityPast() || this.m_MinFileTimestamp.isInfinityFuture() ? -1L : this.m_MinFileTimestamp.dateValue().getTime();
        long maxFileAge = this.m_MaxFileTimestamp.isInfinityPast() || this.m_MaxFileTimestamp.isInfinityFuture() ? -1L : this.m_MaxFileTimestamp.dateValue().getTime();
        for (int i = 0; i < currFiles.length; ++i) {
            if (currFiles[i].isFile() && currFiles[i].getName().equals(this.m_StopFile)) {
                this.m_StopFileEncountered = true;
                if (!this.getDebug()) break;
                this.debug("stop file encountered");
                break;
            }
            if (this.m_Stopped) break;
            if (currFiles[i].isDirectory()) {
                if (currFiles[i].getName().equals(".") || currFiles[i].getName().equals("..")) continue;
                if (this.m_Recursive) {
                    this.search(currFiles[i], files, depth - 1);
                }
                if (!this.m_ListDirs || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatch(currFiles[i].getName()) || minFileAge != -1L && minFileAge > currFiles[i].lastModified() || maxFileAge != -1L && maxFileAge < currFiles[i].lastModified()) continue;
                if (this.m_SkipLockedFiles && this.isFileLocked(currFiles[i])) {
                    if (!this.getDebug()) continue;
                    this.debug("file locked, skipping: " + currFiles[i]);
                    continue;
                }
                files.add(new SortContainer(currFiles[i], this.m_Sorting));
                continue;
            }
            if (!this.m_ListFiles || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatch(currFiles[i].getName()) || minFileAge != -1L && minFileAge > currFiles[i].lastModified() || maxFileAge != -1L && maxFileAge < currFiles[i].lastModified()) continue;
            if (this.m_SkipLockedFiles && this.isFileLocked(currFiles[i])) {
                if (!this.getDebug()) continue;
                this.debug("file locked, skipping: " + currFiles[i]);
                continue;
            }
            files.add(new SortContainer(currFiles[i], this.m_Sorting));
        }
    }

    public String[] list() {
        Vector<String> result = new Vector<String>();
        this.m_Stopped = false;
        this.m_StopFileEncountered = false;
        if (this.m_ListFiles || this.m_ListDirs) {
            int i;
            if (this.getDebug()) {
                this.debug("watching '" + this.m_WatchDir + "'");
            }
            if (this.getDebug()) {
                this.debug("before search(...)");
            }
            Vector<SortContainer> list = new Vector<SortContainer>();
            this.search(new File(this.m_WatchDir.getAbsolutePath()), list, this.m_MaxDepth);
            if (this.getDebug()) {
                this.debug("before obtaining last modified timestamps");
            }
            if (!this.m_Stopped && !this.m_StopFileEncountered && this.m_Sorting != Sorting.NO_SORTING) {
                if (this.getDebug()) {
                    this.debug("before sorting");
                }
                Collections.sort(list);
                if (this.m_SortDescending) {
                    for (i = 0; i < list.size() / 2; ++i) {
                        SortContainer cont = list.get(i);
                        list.set(i, list.get(list.size() - 1 - i));
                        list.set(list.size() - 1 - i, cont);
                    }
                }
            }
            if (!this.m_StopFileEncountered && !this.m_Stopped) {
                if (this.getDebug()) {
                    this.debug("before matching");
                }
                for (i = 0; i < list.size(); ++i) {
                    result.add(list.get(i).getFile().getAbsolutePath());
                    if (this.m_MaxItems > 0 && result.size() == this.m_MaxItems) {
                        if (!this.getDebug()) break;
                        this.debug("max size reached");
                        break;
                    }
                    if (this.m_Stopped) break;
                }
            }
        }
        if (this.m_Stopped) {
            result.clear();
        }
        return result.toArray(new String[result.size()]);
    }

    public String toString() {
        String result = "WatchDir=" + this.m_WatchDir + ", ";
        result = result + "ListDirs=" + this.m_ListDirs + ", ";
        result = result + "ListFiles=" + this.m_ListFiles + ", ";
        result = result + "MaxItems=" + this.m_MaxItems + ", ";
        result = result + "RegExp=" + this.m_RegExp + ", ";
        result = result + "Sorting=" + (Object)((Object)this.m_Sorting) + ", ";
        result = result + "Descending=" + this.m_SortDescending + ", ";
        result = result + "StopFile=" + this.m_StopFile;
        return result;
    }

    public static void main(String[] args) throws Exception {
        DirectoryLister lister = new DirectoryLister();
        String[] list = lister.list();
        for (int i = 0; i < list.length; ++i) {
            System.out.println(i + 1 + ". " + list[i]);
        }
        System.out.println(lister);
    }

    public static class SortContainer
    implements Comparable<SortContainer> {
        protected File m_File;
        protected Comparable m_Sort;

        public SortContainer(File file, Sorting sorting) {
            this.m_File = file;
            if (sorting == Sorting.NO_SORTING) {
                this.m_Sort = null;
            } else if (sorting == Sorting.SORT_BY_NAME) {
                this.m_Sort = file.getAbsolutePath();
            } else if (sorting == Sorting.SORT_BY_LAST_MODIFIED) {
                this.m_Sort = new Long(file.lastModified());
            } else {
                throw new IllegalArgumentException("Unhandled sorting: " + (Object)((Object)sorting));
            }
        }

        public File getFile() {
            return this.m_File;
        }

        @Override
        public int compareTo(SortContainer o) {
            if (this.m_Sort == null) {
                return 0;
            }
            return this.m_Sort.compareTo(o.m_Sort);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SortContainer)) {
                return false;
            }
            return this.compareTo((SortContainer)obj) == 0;
        }

        public String toString() {
            return "file=" + this.m_File.toString() + ", sorting=" + this.m_Sort;
        }
    }

    public static enum Sorting {
        NO_SORTING,
        SORT_BY_NAME,
        SORT_BY_LAST_MODIFIED;

    }
}

