/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.io.FileUtils;
import adams.core.management.Java;
import adams.core.management.ProcessUtils;
import java.io.File;

public class JMap
extends Java {
    public static final String EXECUTABLE = "jmap";

    public static boolean isAvailable() {
        boolean result = JMap.isJDK();
        if (result) {
            result = new File(JMap.getBinDir() + File.separator + FileUtils.fixExecutable(EXECUTABLE)).exists();
        }
        return result;
    }

    public static String getExecutablePath() {
        String result = JMap.getBinDir() + File.separator + FileUtils.fixExecutable(EXECUTABLE);
        result = FileUtils.quoteExecutable(result);
        return result;
    }

    public static String getDefaultOptions() {
        return "-histo:live";
    }

    public static String execute(long pid) {
        return JMap.execute(JMap.getDefaultOptions(), pid);
    }

    public static String execute(String options, long pid) {
        return JMap.execute(JMap.getExecutablePath(), options, pid);
    }

    public static String execute(String executable, String options, long pid) {
        if (pid == -999L) {
            pid = ProcessUtils.getVirtualMachinePID();
        }
        options = options + " " + pid;
        return JMap.execute(executable, options);
    }
}

