/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.NotesHandler;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.utils.SavitzkyGolay;
import java.util.List;

public abstract class AbstractSavitzkyGolay<T extends DataContainer>
extends AbstractFilter<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 7714239052976065971L;
    protected int m_PolynomialOrder;
    protected int m_DerivativeOrder;
    protected int m_NumPointsLeft;
    protected int m_NumPointsRight;
    protected double[] m_Coefficients;

    @Override
    public String globalInfo() {
        return "A filter that applies Savitzky-Golay smoothing.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A. Savitzky and Marcel J.E. Golay");
        result.setValue(TechnicalInformation.Field.TITLE, "Smoothing and Differentiation of Data by Simplified Least Squares Procedures");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Analytical Chemistry");
        result.setValue(TechnicalInformation.Field.VOLUME, "36");
        result.setValue(TechnicalInformation.Field.PAGES, "1627-1639");
        result.setValue(TechnicalInformation.Field.YEAR, "1964");
        result.setValue(TechnicalInformation.Field.HTTP, "http://dx.doi.org/10.1021/ac60214a047");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INBOOK);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "William H. Press and Saul A. Teukolsky and William T. Vetterling and Brian P. Flannery");
        additional.setValue(TechnicalInformation.Field.SERIES, "Numerical Recipes in C");
        additional.setValue(TechnicalInformation.Field.EDITION, "Second");
        additional.setValue(TechnicalInformation.Field.TITLE, "Savitzky-Golay Smoothing Filters");
        additional.setValue(TechnicalInformation.Field.CHAPTER, "14.8");
        additional.setValue(TechnicalInformation.Field.PAGES, "650-655");
        additional.setValue(TechnicalInformation.Field.YEAR, "1992");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Cambridge University Press");
        additional.setValue(TechnicalInformation.Field.PDF, "http://www.nrbook.com/a/bookcpdf/c14-8.pdf");
        return result;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Coefficients = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("polynomial", "polynomialOrder", 2, 2, null);
        this.m_OptionManager.add("derivative", "derivativeOrder", 1, 0, null);
        this.m_OptionManager.add("left", "numPointsLeft", 3, 0, null);
        this.m_OptionManager.add("right", "numPointsRight", 3, 0, null);
    }

    public void resetCoefficients() {
        this.m_Coefficients = null;
    }

    public void setPolynomialOrder(int value) {
        if (value >= 2) {
            this.m_PolynomialOrder = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getSystemErr().println("The polynomial order must be at least 2 (provided: " + value + ")!");
        }
    }

    public int getPolynomialOrder() {
        return this.m_PolynomialOrder;
    }

    public String polynomialOrderTipText() {
        return "The polynomial order to use, must be at least 2.";
    }

    public void setDerivativeOrder(int value) {
        if (value >= 0) {
            this.m_DerivativeOrder = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getSystemErr().println("The order of the derivative must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getDerivativeOrder() {
        return this.m_DerivativeOrder;
    }

    public String derivativeOrderTipText() {
        return "The order of the derivative to use, >= 0.";
    }

    public void setNumPointsLeft(int value) {
        if (value >= 0) {
            this.m_NumPointsLeft = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getSystemErr().println("The number of points to the left must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getNumPointsLeft() {
        return this.m_NumPointsLeft;
    }

    public String numPointsLeftTipText() {
        return "The number of points left of a data point, >= 0.";
    }

    public void setNumPointsRight(int value) {
        if (value >= 0) {
            this.m_NumPointsRight = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getSystemErr().println("The number of points to the right must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getNumPointsRight() {
        return this.m_NumPointsRight;
    }

    public String numPointsRightTipText() {
        return "The number of points right of a data point, >= 0.";
    }

    protected abstract double getValue(DataPoint var1);

    protected abstract DataPoint newDataPoint(DataPoint var1, double var2);

    protected void postProcess(DataPoint oldPoint, DataPoint newPoint) {
    }

    @Override
    protected T processData(T data) {
        if (this.m_Coefficients == null) {
            if (data.size() < this.m_NumPointsLeft + this.m_NumPointsRight + 1) {
                this.getSystemErr().println("Not enough data points: #" + data);
                DataContainer result = (DataContainer)data.getClone();
                if (result instanceof NotesHandler) {
                    ((NotesHandler)((Object)result)).getNotes().addWarning(this.getClass(), "Not enough data points!");
                }
                return (T)result;
            }
            this.m_Coefficients = SavitzkyGolay.determineCoefficients(this.m_NumPointsLeft, this.m_NumPointsRight, this.m_PolynomialOrder, this.m_DerivativeOrder, this.isDebugOn());
        }
        DataContainer result = data.getHeader();
        List points = data.toList();
        int width = this.m_NumPointsLeft + this.m_NumPointsRight + 1;
        for (int i = 0; i <= points.size() - width; ++i) {
            double value = 0.0;
            for (int n = 0; n < width; ++n) {
                value += this.m_Coefficients[n] * this.getValue((DataPoint)points.get(i + n));
            }
            DataPoint newPoint = this.newDataPoint((DataPoint)points.get(i + this.m_NumPointsLeft), value);
            this.postProcess((DataPoint)points.get(i + this.m_NumPointsLeft), newPoint);
            result.add(newPoint);
        }
        return (T)result;
    }
}

