/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.db.BulkInsertTable;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class MultipleInsert
implements Serializable {
    private static final long serialVersionUID = 6066126049923343182L;
    protected StringBuilder m_sb = new StringBuilder();
    protected int count = 0;
    protected int m_insert_at = 250;
    protected BulkInsertTable m_insert;
    protected Vector<String> m_cols = null;

    public MultipleInsert(int max) {
        this.m_insert_at = max;
    }

    public void setTable(BulkInsertTable bti) {
        this.m_insert = bti;
    }

    public void setColumnVector(Vector<String> sv) {
        this.m_cols = sv;
    }

    public String insert(Hashtable<String, String> vals) {
        String ret = null;
        String q = "(";
        for (int i = 0; i < this.m_cols.size(); ++i) {
            String val = vals.get(this.m_cols.elementAt(i));
            if (val == null) {
                System.err.println("null in insert");
                return null;
            }
            q = q + val;
            if (i == this.m_cols.size() - 1) continue;
            q = q + ",";
        }
        q = q + ")";
        if (this.m_sb.length() + q.length() + 1 > 524288) {
            ret = this.getInsertString();
        }
        if (this.count != 0) {
            this.m_sb.append(",");
        } else {
            this.m_sb.append(this.m_insert.generateInsertHeader());
        }
        ++this.count;
        this.m_sb.append(q);
        if (ret != null) {
            return ret;
        }
        if (this.count % this.m_insert_at == 0) {
            return this.getInsertString();
        }
        return null;
    }

    public boolean insertComplete() {
        return this.m_insert.insertComplete(this);
    }

    public String getInsertString() {
        if (this.count == 0) {
            return null;
        }
        String ret = this.m_sb.toString();
        this.count = 0;
        this.m_sb = new StringBuilder();
        return ret;
    }
}

