/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Performance;
import adams.event.JobCompleteManagerChangeEvent;
import adams.event.JobCompleteManagerChangeListener;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTable;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.multiprocess.JobCompleteManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class JobCompleteManagerPanel
extends BasePanel
implements JobCompleteManagerChangeListener {
    private static final long serialVersionUID = -5632965108439630903L;
    protected Vector<JobCompleteManager.JobCompleteInformation> m_Informations;
    protected JobCompleteManager m_Manager;
    protected JobCompleteTable m_TableInformations;
    protected JTextArea m_TextDetails;
    protected JButton m_ButtonClear;
    protected JButton m_ButtonClose;

    public JobCompleteManagerPanel() {
        this.m_Manager.addChangeListener(this);
        this.stateChanged(new JobCompleteManagerChangeEvent(this.m_Manager, JobCompleteManagerChangeEvent.Type.RESET));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Informations = new Vector();
        this.m_Manager = JobCompleteManager.getSingleton();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panel2 = new JPanel(new GridLayout(2, 1, 0, 5));
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)panel2, "Center");
        this.m_TableInformations = new JobCompleteTable();
        this.m_TableInformations.setAutoResizeMode(0);
        this.m_TableInformations.setSelectionMode(0);
        this.m_TableInformations.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = JobCompleteManagerPanel.this.m_TableInformations.getSelectedRow();
                if (MouseUtils.isDoubleClick(e) && index > -1) {
                    JobCompleteManagerPanel.this.showDetails(JobCompleteManagerPanel.this.m_TableInformations.getJobCompleteModel().getInformations().get(index));
                }
            }
        });
        this.m_TableInformations.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JobCompleteManagerPanel.this.updateDetails(JobCompleteManagerPanel.this.m_TableInformations.getJobCompleteModel().getInformations().get(JobCompleteManagerPanel.this.m_TableInformations.getSelectedRow()));
            }
        });
        panel2.add(new BaseScrollPane(this.m_TableInformations));
        this.m_TextDetails = new JTextArea();
        this.m_TextDetails.setFont(new Font("monospace", 0, 12));
        this.m_TextDetails.setEditable(false);
        panel2.add(new BaseScrollPane(this.m_TextDetails));
        panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add((Component)panel2, "South");
        JPanel panel = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "West");
        if (Performance.getKeepOnlyFailedJobComplete()) {
            panel.add((Component)new JLabel("Only failed jobs listed"), "West");
        } else {
            panel.add((Component)new JLabel("All finished jobs listed"), "West");
        }
        panel = new JPanel(new FlowLayout(2));
        panel2.add((Component)panel, "East");
        this.m_ButtonClear = new JButton("Clear", GUIHelper.getIcon("new.gif"));
        this.m_ButtonClear.setMnemonic('C');
        this.m_ButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobCompleteManagerPanel.this.m_Manager.clear();
            }
        });
        this.m_ButtonClose = new JButton("Close", GUIHelper.getIcon("exit.png"));
        this.m_ButtonClose.setMnemonic('l');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobCompleteManagerPanel.this.close();
            }
        });
        panel.add(this.m_ButtonClear);
        panel.add(this.m_ButtonClose);
    }

    public void close() {
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    protected void showDetails(JobCompleteManager.JobCompleteInformation information) {
        GUIHelper.showInformationMessage(this, information.getJobResult().toString(), "Job result details");
    }

    protected void updateDetails(JobCompleteManager.JobCompleteInformation information) {
        if (information == null) {
            this.m_TextDetails.setText("");
        } else {
            this.m_TextDetails.setText(information.getJobResult().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stateChanged(JobCompleteManagerChangeEvent e) {
        Vector<JobCompleteManager.JobCompleteInformation> informations = e.getManager().getInformations();
        if (e.getType() == JobCompleteManagerChangeEvent.Type.RESET) {
            Vector<JobCompleteManager.JobCompleteInformation> vector = this.m_Informations = new Vector();
            synchronized (vector) {
                this.m_Informations.addAll(informations);
                JobCompleteTable jobCompleteTable = this.m_TableInformations;
                synchronized (jobCompleteTable) {
                    this.m_TableInformations.getJobCompleteModel().set(this.m_Informations);
                }
            }
        }
        informations.removeAll(this.m_Informations);
        Vector<JobCompleteManager.JobCompleteInformation> vector = this.m_Informations;
        synchronized (vector) {
            this.m_Informations.addAll(informations);
            JobCompleteTable jobCompleteTable = this.m_TableInformations;
            synchronized (jobCompleteTable) {
                this.m_TableInformations.getJobCompleteModel().append(informations);
            }
        }
        this.m_TableInformations.setOptimalColumnWidth();
    }

    public static class JobCompleteTable
    extends BaseTable {
        private static final long serialVersionUID = 1829018507165434360L;

        public JobCompleteTable() {
            super(new JobCompleteTableModel(null));
        }

        @Override
        public synchronized void setModel(TableModel value) {
            if (!(value instanceof JobCompleteTableModel)) {
                throw new IllegalArgumentException("Model must be of type " + JobCompleteTableModel.class.getName());
            }
            super.setModel(value);
        }

        public JobCompleteTableModel getJobCompleteModel() {
            return (JobCompleteTableModel)this.getModel();
        }
    }

    public static class JobCompleteTableModel
    extends AbstractBaseTableModel {
        private static final long serialVersionUID = 3369969274010850739L;
        protected Vector<JobCompleteManager.JobCompleteInformation> m_Informations;

        public JobCompleteTableModel(Vector<JobCompleteManager.JobCompleteInformation> informations) {
            this.set(informations);
        }

        @Override
        public int getRowCount() {
            return this.m_Informations.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            String result = null;
            if (column == 0) {
                result = "Job class";
            } else if (column == 1) {
                result = "Success";
            } else if (column == 2) {
                result = "Details";
            }
            return result;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = null;
            if (column == 0) {
                String s = this.m_Informations.get(row).getJobClass();
                s = s.replaceAll(".*\\.", "");
                s = s.replaceAll("\\$", "/");
                s = s.replaceAll("Abstract", "");
                result = s;
            } else if (column == 1) {
                result = this.m_Informations.get(row).getJobResult().getSuccess();
            } else if (column == 2) {
                result = this.m_Informations.get(row).getJobDetails();
            }
            return result;
        }

        public Class getColumnClass(int column) {
            Class result = String.class;
            if (column == 0) {
                result = String.class;
            } else if (column == 1) {
                result = Boolean.class;
            } else if (column == 2) {
                result = String.class;
            }
            return result;
        }

        public Vector<JobCompleteManager.JobCompleteInformation> getInformations() {
            return this.m_Informations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void set(Vector<JobCompleteManager.JobCompleteInformation> informations) {
            Vector<JobCompleteManager.JobCompleteInformation> vector = this.m_Informations = new Vector();
            synchronized (vector) {
                if (informations != null) {
                    this.m_Informations.addAll(informations);
                }
            }
            this.fireTableDataChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void append(Vector<JobCompleteManager.JobCompleteInformation> informations) {
            int toRow;
            int fromRow;
            Vector<JobCompleteManager.JobCompleteInformation> vector = this.m_Informations;
            synchronized (vector) {
                fromRow = this.m_Informations.size();
                this.m_Informations.addAll(informations);
                toRow = this.m_Informations.size() - 1;
            }
            this.fireTableRowsInserted(fromRow, toRow);
        }
    }
}

