/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.data.filter.PassThrough;
import adams.gui.core.BaseDialog;
import adams.gui.event.FilterEvent;
import adams.gui.event.FilterListener;
import adams.gui.goe.GenericObjectEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FilterDialog<T extends DataContainer>
extends BaseDialog {
    private static final long serialVersionUID = 3690400655773745448L;
    protected AbstractFilter<T> m_CurrentFilter;
    protected GenericObjectEditorPanel m_PanelFilter;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonCancel;
    protected JCheckBox m_CheckboxOverlay;
    protected FilterListener m_FilterListener;

    public FilterDialog(Dialog owner) {
        super(owner, "Filter");
    }

    public FilterDialog(Frame owner) {
        super(owner, "Filter");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CurrentFilter = new PassThrough();
        this.m_FilterListener = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.getContentPane().setLayout(new BorderLayout());
        this.m_PanelFilter = new GenericObjectEditorPanel(AbstractFilter.class, this.m_CurrentFilter, true);
        this.m_PanelFilter.setPrefix("Filter");
        this.m_PanelFilter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FilterDialog.this.m_CurrentFilter = (AbstractFilter)((GenericObjectEditorPanel)e.getSource()).getCurrent();
            }
        });
        this.m_CheckboxOverlay = new JCheckBox("Overlay original data");
        this.m_CheckboxOverlay.setMnemonic('d');
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.setVisible(false);
                if (FilterDialog.this.m_FilterListener != null) {
                    FilterDialog.this.m_FilterListener.filter(new FilterEvent(FilterDialog.this, FilterDialog.this.m_CurrentFilter, FilterDialog.this.m_CheckboxOverlay.isSelected()));
                }
            }
        });
        this.m_ButtonCancel = new JButton("Cancel");
        this.m_ButtonCancel.setMnemonic('C');
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.setVisible(false);
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel2.add((Component)this.m_PanelFilter, "Center");
        this.getContentPane().add((Component)panel2, "North");
        panel2 = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel2, "Center");
        JPanel panel = new JPanel(new FlowLayout(0));
        panel2.add((Component)panel, "North");
        panel.add(this.m_CheckboxOverlay);
        panel2 = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel2, "South");
        panel = new JPanel(new FlowLayout(2));
        panel2.add((Component)panel, "North");
        panel.add(this.m_ButtonOK);
        panel.add(this.m_ButtonCancel);
        this.pack();
    }

    public void setFilter(AbstractFilter<T> value) {
        this.m_CurrentFilter = value;
        this.m_PanelFilter.setCurrent(value);
    }

    public AbstractFilter<T> getFilter() {
        return this.m_CurrentFilter;
    }

    public void setOverlayOriginalData(boolean value) {
        this.m_CheckboxOverlay.setSelected(value);
    }

    public boolean getOverlayOriginalData() {
        return this.m_CheckboxOverlay.isSelected();
    }

    public void setFilterListener(FilterListener value) {
        this.m_FilterListener = value;
    }

    public FilterListener getFilterListener() {
        return this.m_FilterListener;
    }

    @Override
    protected void beforeShow() {
        super.beforeShow();
        this.m_PanelFilter.grabFocus();
    }
}

