/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.benchmark.AbstractBenchmarkTask;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.BenchmarkResult;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.util.SerializationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MtimesBenchmarkTask
extends AbstractBenchmarkTask {
    public MtimesBenchmarkTask(long benchmarkSeed, Class<? extends DoubleMatrix2D> matrixClass, BenchmarkConfig config) {
        super(benchmarkSeed, matrixClass, config.getMtimesSizes(), config);
    }

    @Override
    public BenchmarkResult task(Class<? extends Matrix> matrixClass, long benchmarkSeed, int run, long[] size) {
        Matrix r = null;
        try {
            DoubleMatrix2D m0 = BenchmarkUtil.createMatrix(matrixClass, size);
            if (!m0.getClass().getName().startsWith("org.ujmp.core") && m0.getClass().getDeclaredMethod("mtimes", Matrix.class) == null) {
                System.out.print("-");
                System.out.flush();
                return BenchmarkResult.NOTAVAILABLE;
            }
            DoubleMatrix2D m1 = BenchmarkUtil.createMatrix(matrixClass, Coordinates.transpose(size));
            BenchmarkUtil.rand(benchmarkSeed, run, 0, m0);
            BenchmarkUtil.rand(benchmarkSeed, run, 1, m1);
            BenchmarkUtil.purgeMemory(this.getConfig());
            long e0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            long t0 = System.nanoTime();
            r = m0.mtimes(m1);
            long t1 = System.nanoTime();
            long e1 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (r == null) {
                System.out.print("e");
                System.out.flush();
                return BenchmarkResult.ERROR;
            }
            long mem = e1 - e0 - SerializationUtil.sizeOf(r);
            mem = mem > 0L ? mem : 0L;
            return new BenchmarkResult((double)(t1 - t0) / 1000000.0, mem);
        }
        catch (Throwable e) {
            System.out.print("e");
            System.out.flush();
            return BenchmarkResult.ERROR;
        }
    }

    @Override
    public String getTaskName() {
        return "mtimes";
    }
}

