/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.CoordinateIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCalculation
implements Calculation {
    private static final long serialVersionUID = -36063772015381070L;
    private Matrix[] sources = null;
    private int dimension = -1;
    private Annotation annotation = null;

    public AbstractCalculation(Matrix ... sources) {
        this.sources = sources;
        this.annotation = sources.length == 0 ? null : sources[0].getAnnotation();
    }

    public AbstractCalculation(int dimension, Matrix ... sources) {
        this.sources = sources;
        this.annotation = sources.length == 0 ? null : sources[0].getAnnotation();
        this.dimension = dimension;
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public long getValueCount() {
        return Coordinates.product(this.getSize());
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return this.allCoordinates();
    }

    @Override
    public Iterable<long[]> allCoordinates() {
        return new CoordinateIterator(this.getSize());
    }

    @Override
    public boolean contains(long ... coordinates) {
        return Coordinates.isSmallerThan(coordinates, this.getSize());
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public final Matrix getSource() {
        return this.sources[0];
    }

    @Override
    public final Matrix[] getSources() {
        return this.sources;
    }

    @Override
    public void setSources(Matrix ... sources) {
        this.sources = sources;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Override
    public long[] getSize() {
        return this.getSource().getSize();
    }

    @Override
    public final Matrix calc(Calculation.Ret returnType) throws MatrixException {
        switch (returnType) {
            case ORIG: {
                return this.calcOrig();
            }
            case LINK: {
                return this.calcLink();
            }
        }
        return this.calcNew();
    }

    @Override
    public Matrix[] calcMulti() throws MatrixException {
        return new Matrix[]{this.calcNew()};
    }

    @Override
    public final Matrix.StorageType getStorageType() {
        return this.getSource().getStorageType();
    }
}

