/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.annotation.DefaultAnnotation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.CountMissing;
import org.ujmp.core.doublematrix.calculation.general.statistical.Mean;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class Var
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -6376910948253374396L;
    private Matrix mean = null;
    private Matrix missingCount = null;
    private boolean ignoreNaN = false;

    public Var(int dimension, boolean ignoreNaN, Matrix matrix) {
        super(dimension, matrix);
        this.ignoreNaN = ignoreNaN;
        Annotation aold = matrix.getAnnotation();
        if (aold != null) {
            DefaultAnnotation a = new DefaultAnnotation(this.getSize());
            a.setMatrixAnnotation(aold.getMatrixAnnotation());
            if (dimension == 0) {
                a.setDimensionMatrix(0, aold.getDimensionMatrix(0));
            } else if (dimension == 1) {
                a.setDimensionMatrix(1, aold.getDimensionMatrix(1));
            }
            this.setAnnotation(a);
        }
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        if (this.mean == null) {
            this.mean = new Mean(this.getDimension(), this.ignoreNaN, this.getSource()).calcNew();
        }
        if (this.missingCount == null) {
            this.missingCount = new CountMissing(this.getDimension(), this.getSource()).calcNew();
        }
        double sum = 0.0;
        if (this.ignoreNaN) {
            double count = 0.0;
            switch (this.getDimension()) {
                case 0: {
                    long r = this.getSource().getSize()[0] - 1L;
                    while (r != -1L) {
                        sum += Math.pow(MathUtil.ignoreNaN(this.getSource().getAsDouble(r--, coordinates[1])) - this.mean.getAsDouble(0L, coordinates[1]), 2.0);
                    }
                    count = (double)this.getSource().getRowCount() - this.missingCount.getAsDouble(0L, coordinates[1]) - 1.0;
                    count = count == 0.0 ? 1.0 : count;
                    return sum / count;
                }
                case 1: {
                    long c = this.getSource().getSize()[1] - 1L;
                    while (c != -1L) {
                        sum += Math.pow(MathUtil.ignoreNaN(this.getSource().getAsDouble(coordinates[0], c--)) - this.mean.getAsDouble(coordinates[0], 0L), 2.0);
                    }
                    count = (double)this.getSource().getColumnCount() - this.missingCount.getAsDouble(coordinates[0], 0L) - 1.0;
                    count = count == 0.0 ? 1.0 : count;
                    return sum / count;
                }
                case 0x7FFFFFFF: {
                    long r = this.getSource().getSize()[0] - 1L;
                    while (r != -1L) {
                        long c = this.getSource().getSize()[1] - 1L;
                        while (c != -1L) {
                            sum += Math.pow(MathUtil.ignoreNaN(this.getSource().getAsDouble(r, c--)) - this.mean.getAsDouble(0L, 0L), 2.0);
                        }
                        --r;
                    }
                    count = (double)Coordinates.product(this.getSource().getSize()) - this.missingCount.getAsDouble(0L, 0L) - 1.0;
                    count = count == 0.0 ? 1.0 : count;
                    return sum / count;
                }
            }
            return 0.0;
        }
        double count = 0.0;
        switch (this.getDimension()) {
            case 0: {
                long r = this.getSource().getSize()[0] - 1L;
                while (r != -1L) {
                    sum += Math.pow(this.getSource().getAsDouble(r--, coordinates[1]) - this.mean.getAsDouble(0L, coordinates[1]), 2.0);
                }
                count = this.getSource().getRowCount() - 1L;
                count = count == 0.0 ? 1.0 : count;
                return sum / count;
            }
            case 1: {
                long c = this.getSource().getSize()[1] - 1L;
                while (c != -1L) {
                    sum += Math.pow(this.getSource().getAsDouble(coordinates[0], c--) - this.mean.getAsDouble(coordinates[0], 0L), 2.0);
                }
                count = this.getSource().getColumnCount() - 1L;
                count = count == 0.0 ? 1.0 : count;
                return sum / count;
            }
            case 0x7FFFFFFF: {
                long r = this.getSource().getSize()[0] - 1L;
                while (r != -1L) {
                    long c = this.getSource().getSize()[1] - 1L;
                    while (c != -1L) {
                        sum += Math.pow(this.getSource().getAsDouble(r, c--) - this.mean.getAsDouble(0L, 0L), 2.0);
                    }
                    --r;
                }
                count = Coordinates.product(this.getSource().getSize()) - 1L;
                count = count == 0.0 ? 1.0 : count;
                return sum / count;
            }
        }
        return 0.0;
    }

    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        return null;
    }
}

