/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.genericmatrix.impl;

import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.genericmatrix.stub.AbstractSparseGenericMatrix;
import org.ujmp.core.util.CoordinateSetToLongWrapper;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSparseGenericMatrix<A>
extends AbstractSparseGenericMatrix<A> {
    private static final long serialVersionUID = -7139128532871448340L;
    private final Map<Coordinates, A> values = new HashMap<Coordinates, A>();
    private long[] size;
    private int maximumNumberOfEntries = -1;

    public DefaultSparseGenericMatrix(Matrix m) throws MatrixException {
        this(m, -1);
    }

    public DefaultSparseGenericMatrix(Matrix m, int maximumNumberOfEntries) throws MatrixException {
        this(m.getSize());
        this.maximumNumberOfEntries = maximumNumberOfEntries;
        for (long[] c : m.availableCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
    }

    public DefaultSparseGenericMatrix(long ... size) {
        VerifyUtil.assertTrue(size.length > 1, "matrix must have at least two dimensions");
        this.size = Coordinates.copyOf(size);
    }

    public DefaultSparseGenericMatrix(int maximumNumberOfEntries, long ... size) {
        this(size);
        this.maximumNumberOfEntries = maximumNumberOfEntries;
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public void setSize(long ... size) {
        this.size = size;
    }

    @Override
    public A getObject(long ... coordinates) {
        return this.values.get(new Coordinates(coordinates));
    }

    @Override
    public long getValueCount() {
        return this.values.size();
    }

    @Override
    public void setObject(Object value, long ... coordinates) {
        while (this.maximumNumberOfEntries > 0 && this.values.size() > this.maximumNumberOfEntries) {
            this.values.remove(this.values.keySet().iterator().next());
        }
        if (Coordinates.isSmallerThan(coordinates, this.size)) {
            if (MathUtil.isNull(value)) {
                this.values.remove(new Coordinates(coordinates));
            } else {
                this.values.put(new Coordinates(coordinates), value);
            }
        }
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new CoordinateSetToLongWrapper(this.values.keySet());
    }

    @Override
    public boolean contains(long ... coordinates) {
        return this.values.containsKey(new Coordinates(coordinates));
    }

    @Override
    public double getAsDouble(long ... coordinates) throws MatrixException {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public void setAsDouble(double value, long ... coordinates) throws MatrixException {
        this.setObject((Object)value, coordinates);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }

    @Override
    public final Matrix.StorageType getStorageType() {
        return Matrix.StorageType.SPARSE;
    }
}

