/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.collections.SoftHashMap;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix;
import org.ujmp.core.util.CoordinateSetToLongWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolatileSparseObjectMatrix
extends AbstractSparseObjectMatrix {
    private static final long serialVersionUID = 392817709394048419L;
    private final Map<Coordinates, Object> values = new SoftHashMap<Coordinates, Object>();
    private long[] size = null;

    public VolatileSparseObjectMatrix(Matrix m) throws MatrixException {
        this.size = Coordinates.copyOf(m.getSize());
        for (long[] c : m.allCoordinates()) {
            this.setAsDouble(m.getAsDouble(c), c);
        }
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    public VolatileSparseObjectMatrix(long ... size) {
        this.size = Coordinates.copyOf(size);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public Object getObject(long ... coordinates) {
        return this.values.get(new Coordinates(coordinates));
    }

    @Override
    public long getValueCount() {
        return this.values.size();
    }

    @Override
    public void setObject(Object value, long ... coordinates) {
        this.values.put(new Coordinates(coordinates), value);
    }

    public Iterable<long[]> entries() {
        return new CoordinateSetToLongWrapper(this.values.keySet());
    }

    @Override
    public boolean contains(long ... coordinates) {
        return this.values.containsKey(new Coordinates(coordinates));
    }
}

