/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.FastMemory;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import de.intarsys.nativec.api.ICallback;
import de.intarsys.nativec.api.INativeCallback;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.INativeInterface;
import de.intarsys.nativec.api.INativeLibrary;
import de.intarsys.nativec.jna.JnaNativeCallback;
import de.intarsys.nativec.jna.JnaNativeFunction;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.jna.JnaNativeLibrary;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JnaNativeInterface
implements INativeInterface {
    private List<String> searchPaths = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader loader;
        ClassLoader classLoader = loader = JnaNativeInterface.class.getClassLoader();
        synchronized (classLoader) {
            try {
                Class.forName("com.sun.jna.Native", true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addSearchPath(String path) {
        if (this.searchPaths.contains(path)) {
            return;
        }
        this.searchPaths.add(path);
    }

    @Override
    public INativeHandle allocate(int size) {
        return new JnaNativeHandle(new FastMemory(size));
    }

    @Override
    public INativeCallback createCallback(ICallback callback) {
        return new JnaNativeCallback(callback);
    }

    @Override
    public INativeFunction createFunction(long address) {
        Pointer pointer = new Pointer(address);
        Function function = Function.getFunction((Pointer)pointer);
        return new JnaNativeFunction(function);
    }

    @Override
    public INativeHandle createHandle(long address) {
        return new JnaNativeHandle(address);
    }

    @Override
    public INativeLibrary createLibrary(String name) {
        return new JnaNativeLibrary(this, name);
    }

    protected List<String> getSearchPaths() {
        return this.searchPaths;
    }

    @Override
    public int longSize() {
        return Native.LONG_SIZE;
    }

    @Override
    public int pointerSize() {
        return Native.POINTER_SIZE;
    }

    @Override
    public int wideCharSize() {
        return 2;
    }
}

