/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSNotSupported;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.ICSDeviceFeatures;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDPostScript;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.tools.geometry.ApplySpaceChangeShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public abstract class CSDeviceAdapter
implements ICSDevice,
ICSDeviceFeatures {
    public static int MAX_STACK_SIZE = 500;
    private AffineTransform deviceTransform = new AffineTransform();
    protected GraphicsState graphicsState;
    private ICSInterpreter interpreter;
    private GraphicsState[] stack = new GraphicsState[MAX_STACK_SIZE];
    private int stackPtr = 0;
    protected TextState textState;

    protected void basicSetNonStrokeColorSpace(PDColorSpace colorSpace) {
        this.graphicsState.nonStrokeColorSpace = colorSpace;
        this.graphicsState.nonStrokeColorValues = null;
    }

    protected void basicSetNonStrokeColorValues(float[] values) {
        this.graphicsState.nonStrokeColorValues = values;
    }

    protected void basicSetStrokeColorSpace(PDColorSpace colorSpace) {
        this.graphicsState.strokeColorSpace = colorSpace;
        this.graphicsState.strokeColorValues = null;
    }

    protected void basicSetStrokeColorValues(float[] values) {
        this.graphicsState.strokeColorValues = values;
    }

    public void close() {
        this.interpreter = null;
    }

    public void compatibilityBegin() {
    }

    public void compatibilityEnd() {
    }

    protected void doForm(COSName name, PDForm form) throws CSException {
        this.saveState();
        try {
            CDSRectangle r;
            CDSMatrix m = form.getMatrix();
            if (m != null) {
                this.transform(m.getA(), m.getB(), m.getC(), m.getD(), m.getE(), m.getF());
            }
            if ((r = form.getBoundingBox()) != null) {
                Rectangle2D tempRect = r.toNormalizedRectangle();
                this.penRectangle((float)tempRect.getMinX(), (float)tempRect.getMinY(), (float)tempRect.getWidth(), (float)tempRect.getHeight());
                this.pathClipNonZero();
                this.pathEnd();
            }
            if (this.interpreter != null) {
                this.interpreter.process(form.getContentStream(), form.getResources());
            }
        }
        finally {
            this.restoreState();
        }
    }

    protected void doImage(COSName name, PDImage image) throws CSException {
    }

    protected void doPostScript(COSName name, PDPostScript postscript) throws CSException {
    }

    public void doShading(COSName name, PDShading shading) {
    }

    public void doXObject(COSName name, PDXObject xobject) {
        if (xobject == null) {
            return;
        }
        if (xobject.isForm()) {
            try {
                this.doForm(name, (PDForm)xobject);
            }
            catch (CSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSError("Unexpected error rendering form", e);
            }
        } else if (xobject.isImage()) {
            try {
                this.doImage(name, (PDImage)xobject);
            }
            catch (CSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSError("Unexpected error rendering image", e);
            }
        } else if (xobject.isPostscript()) {
            try {
                this.doPostScript(name, (PDPostScript)xobject);
            }
            catch (CSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSError("Unexpected error rendering postscript", e);
            }
        } else {
            throw new CSNotSupported("unknown XObject type");
        }
    }

    public AffineTransform getDeviceTransform() {
        return this.deviceTransform;
    }

    public GraphicsState getGraphicsState() {
        return this.graphicsState;
    }

    public ICSInterpreter getInterpreter() {
        return this.interpreter;
    }

    protected GraphicsState graphicsStateCopy(GraphicsState oldState) {
        return oldState.copy();
    }

    protected GraphicsState graphicsStateCreate() {
        return new GraphicsState();
    }

    public void inlineImage(PDImage img) {
    }

    public void markedContentBegin(COSName tag) {
    }

    public void markedContentBeginProperties(COSName tag, COSName resourceName, COSDictionary properties) {
    }

    public void markedContentEnd() {
    }

    public void markedContentPoint(COSName tag) {
    }

    public void markedContentPointProperties(COSName tag, COSName resourceName, COSDictionary properties) {
    }

    public void open(ICSInterpreter pInterpreter) {
        this.interpreter = pInterpreter;
        this.graphicsState = this.graphicsStateCreate();
        this.textState = this.graphicsState.textState;
        this.basicSetNonStrokeColorSpace(PDCSDeviceGray.SINGLETON);
        this.basicSetStrokeColorSpace(PDCSDeviceGray.SINGLETON);
    }

    public void pathClipEvenOdd() {
    }

    public void pathClipNonZero() {
    }

    public void pathClose() {
    }

    public void pathCloseFillStrokeEvenOdd() {
    }

    public void pathCloseFillStrokeNonZero() {
    }

    public void pathCloseStroke() {
    }

    public void pathEnd() {
    }

    public void pathFillEvenOdd() {
    }

    public void pathFillNonZero() {
    }

    public void pathFillStrokeEvenOdd() {
    }

    public void pathFillStrokeNonZero() {
    }

    public void pathStroke() {
    }

    public void penCurveToC(float x1, float y1, float x2, float y2, float x3, float y3) {
    }

    public void penCurveToV(float x2, float y2, float x3, float y3) {
    }

    public void penCurveToY(float x1, float y1, float x3, float y3) {
    }

    public void penLineTo(float x, float y) {
    }

    public void penMoveTo(float x, float y) {
    }

    public void penRectangle(float x, float y, float w, float h) {
    }

    public void restoreState() {
        if (this.stackPtr == 0) {
            throw new RuntimeException("stack underflow");
        }
        --this.stackPtr;
        this.graphicsState = this.stack[this.stackPtr];
        this.textState = this.graphicsState.textState;
    }

    public void saveState() {
        if (this.stackPtr == MAX_STACK_SIZE) {
            throw new RuntimeException("stack overflow");
        }
        this.stack[this.stackPtr++] = this.graphicsState;
        this.graphicsState = this.graphicsStateCopy(this.graphicsState);
        this.textState = this.graphicsState.textState;
    }

    public void setDeviceTransform(AffineTransform deviceTransform) {
        this.deviceTransform = deviceTransform;
    }

    public void setExtendedState(COSName name, PDExtGState gstate) {
        if (gstate == null) {
            return;
        }
        if (this.graphicsState.extState == null) {
            this.graphicsState.extState = (PDExtGState)PDExtGState.META.createFromCos(gstate.cosGetObject().copyShallow());
        } else {
            this.graphicsState.extState.cosGetDict().addAll(gstate.cosGetDict());
        }
        this.graphicsState.capStyle = gstate.getFieldInt(PDExtGState.DK_LC, this.graphicsState.capStyle);
        COSArray cosDash = gstate.cosGetField(PDExtGState.DK_D).asArray();
        if (cosDash != null && cosDash.size() == 2) {
            COSArray cosPattern = cosDash.get(0).asArray();
            COSNumber cosPhase = cosDash.get(1).asNumber();
            if (cosPattern != null && cosPhase != null) {
                float[] pattern = new float[cosPattern.size()];
                int index = 0;
                while (index < cosPattern.size()) {
                    COSNumber number = cosPattern.get(index).asNumber();
                    pattern[index] = number == null ? 0.0f : number.floatValue();
                    ++index;
                }
                this.graphicsState.dashPattern = pattern;
                this.graphicsState.dashPhase = cosPhase.intValue();
            }
        }
        this.graphicsState.joinStyle = gstate.getFieldInt(PDExtGState.DK_LJ, this.graphicsState.joinStyle);
        this.setMiterLimit(gstate.getFieldFixed(PDExtGState.DK_ML, this.graphicsState.miterLimit));
        this.setLineWidth(gstate.getFieldFixed(PDExtGState.DK_LW, this.graphicsState.lineWidth));
        this.graphicsState.strokeAlphaValue = gstate.getFieldFixed(PDExtGState.DK_CA, this.graphicsState.strokeAlphaValue);
        this.graphicsState.nonStrokeAlphaValue = gstate.getFieldFixed(PDExtGState.DK_ca, this.graphicsState.nonStrokeAlphaValue);
    }

    public void setFlatnessTolerance(float flatness) {
    }

    public void setLineCap(int capStyle) {
        this.graphicsState.capStyle = capStyle;
    }

    public void setLineDash(float[] pattern, float phase) {
        this.graphicsState.dashPattern = pattern;
        this.graphicsState.dashPhase = phase;
    }

    public void setLineJoin(int joinStyle) {
        this.graphicsState.joinStyle = joinStyle;
    }

    public void setLineWidth(float lineWidth) {
        this.graphicsState.lineWidth = lineWidth;
    }

    public void setMiterLimit(float miterLimit) {
        this.graphicsState.miterLimit = miterLimit;
    }

    public void setNonStrokeColorCMYK(float c, float m, float y, float k) {
        float[] values;
        PDCSDeviceCMYK colorSpace = PDCSDeviceCMYK.SINGLETON;
        if (this.graphicsState.nonStrokeColorSpace != colorSpace) {
            this.basicSetNonStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, values = new float[]{c, m, y, k})) {
            this.basicSetNonStrokeColorValues(values);
        }
    }

    public void setNonStrokeColorGray(float gray) {
        float[] values;
        PDCSDeviceGray colorSpace = PDCSDeviceGray.SINGLETON;
        if (this.graphicsState.nonStrokeColorSpace != colorSpace) {
            this.basicSetNonStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, values = new float[]{gray})) {
            this.basicSetNonStrokeColorValues(values);
        }
    }

    public void setNonStrokeColorRGB(float r, float g, float b) {
        float[] values;
        PDCSDeviceRGB colorSpace = PDCSDeviceRGB.SINGLETON;
        if (this.graphicsState.nonStrokeColorSpace != colorSpace) {
            this.basicSetNonStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, values = new float[]{r, g, b})) {
            this.basicSetNonStrokeColorValues(values);
        }
    }

    public void setNonStrokeColorSpace(COSName name, PDColorSpace colorSpace) {
        this.basicSetNonStrokeColorSpace(colorSpace);
    }

    public void setNonStrokeColorValues(float[] values) {
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, values)) {
            this.basicSetNonStrokeColorValues(values);
        }
    }

    public void setNonStrokeColorValues(float[] values, COSName name, PDPattern pattern) {
    }

    public void setRenderingIntent(COSName intent) {
    }

    public void setStrokeColorCMYK(float c, float m, float y, float k) {
        float[] values;
        PDCSDeviceCMYK colorSpace = PDCSDeviceCMYK.SINGLETON;
        if (this.graphicsState.strokeColorSpace != colorSpace) {
            this.basicSetStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.strokeColorValues, values = new float[]{c, m, y, k})) {
            this.basicSetStrokeColorValues(values);
        }
    }

    public void setStrokeColorGray(float gray) {
        float[] values;
        PDCSDeviceGray colorSpace = PDCSDeviceGray.SINGLETON;
        if (this.graphicsState.strokeColorSpace != colorSpace) {
            this.basicSetStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.strokeColorValues, values = new float[]{gray})) {
            this.basicSetStrokeColorValues(values);
        }
    }

    public void setStrokeColorRGB(float r, float g, float b) {
        float[] values;
        PDCSDeviceRGB colorSpace = PDCSDeviceRGB.SINGLETON;
        if (this.graphicsState.strokeColorSpace != colorSpace) {
            this.basicSetStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.strokeColorValues, values = new float[]{r, g, b})) {
            this.basicSetStrokeColorValues(values);
        }
    }

    public void setStrokeColorSpace(COSName name, PDColorSpace colorSpace) {
        this.basicSetStrokeColorSpace(colorSpace);
    }

    public void setStrokeColorValues(float[] values) {
        if (!Arrays.equals(this.graphicsState.strokeColorValues, values)) {
            this.basicSetStrokeColorValues(values);
        }
    }

    public void setStrokeColorValues(float[] values, COSName name, PDPattern pattern) {
    }

    public boolean supportsColorSpace() {
        return true;
    }

    public boolean supportsExtendedState() {
        return true;
    }

    public boolean supportsFont() {
        return true;
    }

    public boolean supportsInlineImage() {
        return true;
    }

    public boolean supportsPattern() {
        return true;
    }

    public boolean supportsProperties() {
        return true;
    }

    public boolean supportsShading() {
        return true;
    }

    public boolean supportsXObject() {
        return true;
    }

    public void textBegin() {
        this.textState.lineTransform.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.textState.transform.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.active = true;
    }

    public void textEnd() {
        this.textState.active = false;
    }

    public void textLineMove(float dx, float dy) {
        this.textState.lineTransform.translate(dx, dy);
        this.textState.transform.setTransform(this.textState.lineTransform);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.globalTransform.concatenate(this.textState.transform);
    }

    public void textLineNew() {
        this.textState.lineTransform.translate(0.0, this.textState.leading);
        this.textState.transform.setTransform(this.textState.lineTransform);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.globalTransform.concatenate(this.textState.transform);
    }

    public void textMove(float dx, float dy) {
        this.textState.transform.translate(dx, dy);
        this.textState.globalTransform.translate(dx, dy);
    }

    public void textMoveTo(float x, float y) {
        float dx = x - (float)this.textState.transform.getTranslateX();
        float dy = y - (float)this.textState.transform.getTranslateY();
        this.textMove(dx, dy);
    }

    public void textSetCharSpacing(float charSpacing) {
        this.textState.charSpacing = charSpacing;
        this.textState.derivedCharSpacingScaled = this.textState.charSpacing * this.textState.derivedHorizontalScalingFactor;
    }

    public void textSetFont(COSName name, PDFont font, float size) {
        this.textState.font = font;
        this.textState.fontSize = size;
        this.textState.derivedGlyphAdvanceFactor = this.textState.fontSize / 1000.0f * this.textState.derivedHorizontalScalingFactor;
    }

    public void textSetHorizontalScaling(float scaling) {
        this.textState.horizontalScaling = scaling;
        this.textState.derivedHorizontalScalingFactor = this.textState.horizontalScaling / 100.0f;
        this.textState.derivedGlyphAdvanceFactor = this.textState.fontSize / 1000.0f * this.textState.derivedHorizontalScalingFactor;
        this.textState.derivedCharSpacingScaled = this.textState.charSpacing * this.textState.derivedHorizontalScalingFactor;
        this.textState.derivedWordSpacingScaled = this.textState.wordSpacing * this.textState.derivedHorizontalScalingFactor;
    }

    public void textSetLeading(float leading) {
        this.textState.leading = leading;
    }

    public void textSetRenderingMode(int renderingMode) {
        this.textState.renderingMode = renderingMode;
    }

    public void textSetRise(float rise) {
        this.textState.rise = rise;
    }

    public void textSetTransform(float a, float b, float c, float d, float e, float f) {
        this.textState.lineTransform.setTransform(a, b, c, d, e, f);
        this.textState.transform.setTransform(a, b, c, d, e, f);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.globalTransform.concatenate(this.textState.transform);
    }

    public void textSetWordSpacing(float wordSpacing) {
        this.textState.wordSpacing = wordSpacing;
        this.textState.derivedWordSpacingScaled = this.textState.wordSpacing * this.textState.derivedHorizontalScalingFactor;
    }

    public void textShow(byte[] text, int offset, int length) {
    }

    public void textShow(char[] chars, int offset, int length) {
        byte[] bytes = this.textState.font.getEncoding().encode(chars, offset, length);
        this.textShow(bytes, 0, bytes.length);
    }

    public void textShow(String text) {
        byte[] bytes = this.textState.font.getEncoding().encode(text.toCharArray(), 0, text.length());
        this.textShow(bytes, 0, bytes.length);
    }

    public void textT3SetGlyphWidth(float x, float y) {
    }

    public void textT3SetGlyphWidthBB(float x, float y, float llx, float lly, float urx, float ury) {
    }

    public void transform(float a, float b, float c, float d, float e, float f) {
        AffineTransform transform = new AffineTransform(a, b, c, d, e, f);
        transform.preConcatenate(this.graphicsState.transform);
        this.graphicsState.transform = transform;
        if (this.graphicsState.clip != null) {
            this.graphicsState.clip = ApplySpaceChangeShape.setTransform((Shape)this.graphicsState.clip, (AffineTransform)this.graphicsState.transform);
        }
    }
}

