/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDXObject;
import java.io.IOException;

public class PDImage
extends PDXObject {
    public static final String C_RENDERING_VALID1 = "RelativeColorimetric";
    public static final String C_RENDERING_VALID2 = "AbsoluteColorimetric";
    public static final String C_RENDERING_VALID3 = "Perceptual";
    public static final String C_RENDERING_VALID4 = "Saturation";
    public static final COSName CN_Subtype_Image = COSName.constant("Image");
    public static final COSName DK_Alternates = COSName.constant("Alternates");
    public static final COSName DK_BitsPerComponent = COSName.constant("BitsPerComponent");
    public static final COSName DK_BPC = COSName.constant("BPC");
    public static final COSName DK_ColorSpace = COSName.constant("ColorSpace");
    public static final COSName DK_CS = COSName.constant("CS");
    public static final COSName DK_D = COSName.constant("D");
    public static final COSName DK_Decode = COSName.constant("Decode");
    public static final COSName DK_DecodeParms = COSName.constant("DecodeParms");
    public static final COSName DK_DP = COSName.constant("DP");
    public static final COSName DK_H = COSName.constant("H");
    public static final COSName DK_Height = COSName.constant("Height");
    public static final COSName DK_I = COSName.constant("I");
    public static final COSName DK_ID = COSName.constant("ID");
    public static final COSName DK_IM = COSName.constant("IM");
    public static final COSName DK_ImageMask = COSName.constant("ImageMask");
    public static final COSName DK_Intent = COSName.constant("Intent");
    public static final COSName DK_Interpolate = COSName.constant("Interpolate");
    public static final COSName DK_Mask = COSName.constant("Mask");
    public static final COSName DK_Metadata = COSName.constant("Metadata");
    public static final COSName DK_Name = COSName.constant("Name");
    public static final COSName DK_OC = COSName.constant("OC");
    public static final COSName DK_OPI = COSName.constant("OPI");
    public static final COSName DK_SMask = COSName.constant("SMask");
    public static final COSName DK_SMaskInData = COSName.constant("SMaskInData");
    public static final COSName DK_StructParent = COSName.constant("StructParent");
    public static final COSName DK_W = COSName.constant("W");
    public static final COSName DK_Width = COSName.constant("Width");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private PDColorSpace cachedColorSpace = null;
    private int cachedHeight = -1;
    private int cachedIsImageMask = -1;
    private int cachedIsInterpolate = -1;
    private int cachedWidth = -1;
    private byte[] cachedBytes;

    protected PDImage(COSObject object) {
        super(object);
    }

    public COSStream cosExtractJPEGStream() throws IOException {
        COSStream cosStream = this.cosGetStream();
        while (!(cosStream.getFirstFilter().stringValue().equals("DCTDecode") || cosStream.getFirstFilter().stringValue().equals("DCT") || cosStream.getFirstFilter().stringValue().equals("JPXDecode"))) {
            cosStream = cosStream.copyDecodeFirst();
        }
        return cosStream;
    }

    public COSObject cosGetColorSpace() {
        COSObject object = this.cosGetField(DK_CS);
        if (!object.isNull()) {
            return object;
        }
        return this.cosGetField(DK_ColorSpace);
    }

    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Image;
    }

    public COSObject cosGetMask() {
        return this.cosGetField(DK_Mask);
    }

    public COSArray cosSetColorSpace(COSArray colorspace) {
        return this.cosSetField(DK_ColorSpace, colorspace).asArray();
    }

    public COSName cosSetColorSpace(COSName colorspace) {
        return this.cosSetField(DK_ColorSpace, colorspace).asName();
    }

    public byte[] getAdjustedBytes(int numComponents) {
        if (this.cachedBytes != null) {
            return this.cachedBytes;
        }
        int bitsPerPixel = this.getBitsPerComponent() * numComponents;
        int scanlinePad = (bitsPerPixel + 7) / 8;
        int[] decode = this.getDecode();
        if (decode != null && decode.length == 2 && decode[0] == 1 && decode[1] == 0) {
            this.cachedBytes = this.cosGetStream().getDecodedBytesWritable();
            int index = 0;
            while (index < this.cachedBytes.length) {
                this.cachedBytes[index] = ~this.cachedBytes[index];
                ++index;
            }
        } else {
            this.cachedBytes = this.cosGetStream().getDecodedBytes();
        }
        int expectedSize = this.getHeight() * (((this.getWidth() * bitsPerPixel + 7) / 8 + scanlinePad - 1) / scanlinePad * scanlinePad);
        if (this.cachedBytes.length != expectedSize) {
            byte[] newBytes = new byte[expectedSize];
            System.arraycopy(this.cachedBytes, 0, newBytes, 0, Math.min(this.cachedBytes.length, expectedSize));
            this.cachedBytes = newBytes;
        }
        return this.cachedBytes;
    }

    public int getBitsPerComponent() {
        COSInteger bpc = this.cosGetField(DK_BPC).asInteger();
        if (bpc != null) {
            return bpc.intValue();
        }
        return this.getFieldInt(DK_BitsPerComponent, 1);
    }

    public byte[][] getColorKeyMask(int colors) {
        COSArray colorKeyMask = this.cosGetMask().asArray();
        if (colorKeyMask == null) {
            return null;
        }
        byte[][] bytes = new byte[colorKeyMask.size() / colors][colors];
        int keyIndex = 0;
        while (keyIndex < bytes.length) {
            int colorIndex = 0;
            while (colorIndex < colors) {
                bytes[keyIndex][colorIndex] = (byte)((COSNumber)colorKeyMask.get(keyIndex * colors + colorIndex)).intValue();
                ++colorIndex;
            }
            ++keyIndex;
        }
        return bytes;
    }

    public PDColorSpace getColorSpace() {
        if (this.cachedColorSpace == null) {
            COSObject object = this.cosGetField(DK_CS);
            this.cachedColorSpace = !object.isNull() ? (PDColorSpace)PDColorSpace.META.createFromCos(object) : (PDColorSpace)PDColorSpace.META.createFromCos(this.cosGetField(DK_ColorSpace));
            if (this.cachedColorSpace == null && this.isImageMask()) {
                this.cachedColorSpace = PDCSDeviceGray.SINGLETON;
            }
        }
        return this.cachedColorSpace;
    }

    public int[] getDecode() {
        COSArray cosArray = this.cosGetField(DK_Decode).asArray();
        if (cosArray == null) {
            cosArray = this.cosGetField(DK_D).asArray();
        }
        if (cosArray == null) {
            return null;
        }
        int[] decode = new int[cosArray.size()];
        int index = 0;
        while (index < decode.length) {
            decode[index] = cosArray.get(index).asNumber().intValue();
            ++index;
        }
        return decode;
    }

    public int getHeight() {
        if (this.cachedHeight == -1) {
            this.cachedHeight = this.getFieldInt(DK_Height, -1);
            if (this.cachedHeight == -1) {
                this.cachedHeight = this.getFieldInt(DK_H, 0);
            }
        }
        return this.cachedHeight;
    }

    public PDImage getMaskImage() {
        COSObject mask = this.cosGetMask();
        if (mask.isNull()) {
            return null;
        }
        try {
            return (PDImage)PDXObject.META.createFromCos(mask);
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public PDXObject getSMask() {
        return (PDXObject)PDXObject.META.createFromCos(this.cosGetField(DK_SMask));
    }

    public int getWidth() {
        if (this.cachedWidth == -1) {
            this.cachedWidth = this.getFieldInt(DK_Width, -1);
            if (this.cachedWidth == -1) {
                this.cachedWidth = this.getFieldInt(DK_W, 0);
            }
        }
        return this.cachedWidth;
    }

    public boolean hasTransparency() {
        return !this.cosGetMask().isNull() || this.getSMask() != null;
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedColorSpace = null;
        this.cachedHeight = -1;
        this.cachedWidth = -1;
        this.cachedBytes = null;
        this.cachedIsInterpolate = -1;
        this.cachedIsImageMask = -1;
    }

    public boolean isImage() {
        return true;
    }

    public boolean isImageMask() {
        if (this.cachedIsImageMask == -1) {
            COSBoolean result = this.cosGetField(DK_ImageMask).asBoolean();
            if (result == null) {
                result = this.cosGetField(DK_IM).asBoolean();
            }
            this.cachedIsImageMask = result != null && result.booleanValue() ? 1 : 0;
        }
        return this.cachedIsImageMask == 1;
    }

    public boolean isInterpolate() {
        if (this.cachedIsInterpolate == -1) {
            this.cachedIsInterpolate = this.getFieldBoolean(DK_Interpolate, false) ? 1 : 0;
        }
        return this.cachedIsInterpolate == 1;
    }

    public void setBitsPerComponent(int bits) {
        this.setFieldInt(DK_BitsPerComponent, bits);
    }

    public void setColorSpace(PDColorSpace paramCachedColorSpace) {
        this.cachedColorSpace = paramCachedColorSpace;
    }

    public void setDecode(int[] decode) {
        COSArray cosArray = COSArray.create(decode.length);
        int index = 0;
        while (index < decode.length) {
            cosArray.add(COSInteger.create(decode[index]));
            ++index;
        }
        this.cosSetField(DK_Decode, cosArray);
    }

    public void setHeight(int height) {
        this.setFieldInt(DK_Height, height);
    }

    public void setImageMask(boolean flag) {
        this.setFieldBoolean(DK_ImageMask, flag);
    }

    public void setMask(PDXObject object) {
        this.setFieldObject(DK_Mask, object);
    }

    public void setSMask(PDXObject object) {
        this.setFieldObject(DK_SMask, object);
    }

    public void setWidth(int width) {
        this.setFieldInt(DK_Width, width);
    }

    public static class MetaClass
    extends PDXObject.MetaClass {
        protected MetaClass(Class paramInstanceClass) {
            super(paramInstanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDImage(object);
        }
    }
}

