/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Vector;
import moa.core.Measurement;

public class MOAMeasurementsFilter
extends AbstractTransformer {
    private static final long serialVersionUID = -8877674188038780612L;
    protected BaseRegExp m_RegExp;
    protected boolean m_InvertMatching;

    public String globalInfo() {
        return "Filters the measures based on the measurement name. The matching can be inverted as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invertMatching", (Object)false);
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to use for filtering the measurements.";
    }

    public void setInvertMatching(boolean value) {
        this.m_InvertMatching = value;
        this.reset();
    }

    public boolean getInvertMatching() {
        return this.m_InvertMatching;
    }

    public String invertMatchingTipText() {
        return "Whether to invert the matching sense of the regular expression.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("regExp");
        String result = variable != null ? variable : this.m_RegExp.getValue();
        if (this.m_InvertMatching) {
            result = "!" + result;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Measurement[].class};
    }

    public Class[] generates() {
        return new Class[]{Measurement[].class};
    }

    protected String doExecute() {
        String result = null;
        Measurement[] measurements = (Measurement[])this.m_InputToken.getPayload();
        Vector<Measurement> filtered = new Vector<Measurement>();
        for (int i = 0; i < measurements.length; ++i) {
            if (this.m_InvertMatching) {
                if (this.m_RegExp.isMatch(measurements[i].getName())) continue;
                filtered.add(measurements[i]);
                continue;
            }
            if (!this.m_RegExp.isMatch(measurements[i].getName())) continue;
            filtered.add(measurements[i]);
        }
        if (filtered.size() > 0) {
            this.m_OutputToken = new Token((Object)filtered.toArray(new Measurement[filtered.size()]));
            this.m_OutputToken.setProvenance(this.m_InputToken.getProvenance());
        }
        return result;
    }
}

