/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.quartz.SchedulerException;
import org.quartz.UnableToInterruptJobException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface QuartzSchedulerMBean {
    public static final String SCHEDULER_STARTED = "schedulerStarted";
    public static final String SCHEDULER_PAUSED = "schedulerPaused";
    public static final String SCHEDULER_SHUTDOWN = "schedulerShutdown";
    public static final String SCHEDULER_ERROR = "schedulerError";
    public static final String JOB_ADDED = "jobAdded";
    public static final String JOB_DELETED = "jobDeleted";
    public static final String JOB_SCHEDULED = "jobScheduled";
    public static final String JOB_UNSCHEDULED = "jobUnscheduled";
    public static final String JOBS_PAUSED = "jobsPaused";
    public static final String JOBS_RESUMED = "jobsResumed";
    public static final String JOB_EXECUTION_VETOED = "jobExecutionVetoed";
    public static final String JOB_TO_BE_EXECUTED = "jobToBeExecuted";
    public static final String JOB_WAS_EXECUTED = "jobWasExecuted";
    public static final String TRIGGER_FINALIZED = "triggerFinalized";
    public static final String TRIGGERS_PAUSED = "triggersPaused";
    public static final String TRIGGERS_RESUMED = "triggersResumed";
    public static final String SAMPLED_STATISTICS_ENABLED = "sampledStatisticsEnabled";
    public static final String SAMPLED_STATISTICS_RESET = "sampledStatisticsReset";

    public String getSchedulerName();

    public String getSchedulerInstanceId();

    public boolean isStandbyMode();

    public boolean isShutdown();

    public String getVersion();

    public String getJobStoreClassName();

    public String getThreadPoolClassName();

    public int getThreadPoolSize();

    public long getJobsScheduledMostRecentSample();

    public long getJobsExecutedMostRecentSample();

    public long getJobsCompletedMostRecentSample();

    public Map<String, Long> getPerformanceMetrics();

    public TabularData getCurrentlyExecutingJobs() throws SchedulerException;

    public TabularData getAllJobDetails(String var1) throws SchedulerException;

    public TabularData getAllTriggers(String var1) throws SchedulerException;

    public String[] getJobGroupNames(String var1) throws SchedulerException;

    public String[] getJobNames(String var1, String var2) throws SchedulerException;

    public CompositeData getJobDetail(String var1, String var2, String var3) throws SchedulerException;

    public boolean isStarted();

    public void start() throws SchedulerException;

    public void shutdown();

    public void standby();

    public Date scheduleJob(String var1, String var2, String var3, String var4, String var5) throws SchedulerException;

    public boolean unscheduleJob(String var1, String var2, String var3) throws SchedulerException;

    public boolean interruptJob(String var1, String var2, String var3) throws UnableToInterruptJobException;

    public void triggerJob(String var1, String var2, String var3, Map<String, String> var4) throws SchedulerException;

    public void triggerJobWithVolatileTrigger(String var1, String var2, String var3, Map<String, String> var4) throws SchedulerException;

    public boolean deleteJob(String var1, String var2, String var3) throws SchedulerException;

    public void addJob(String var1, CompositeData var2, boolean var3) throws SchedulerException;

    public void pauseJobGroup(String var1, String var2) throws SchedulerException;

    public void resumeJobGroup(String var1, String var2) throws SchedulerException;

    public void pauseJob(String var1, String var2, String var3) throws SchedulerException;

    public void resumeJob(String var1, String var2, String var3) throws SchedulerException;

    public String[] getTriggerGroupNames(String var1) throws SchedulerException;

    public String[] getTriggerNames(String var1, String var2) throws SchedulerException;

    public CompositeData getTrigger(String var1, String var2, String var3) throws SchedulerException;

    public int getTriggerState(String var1, String var2, String var3) throws SchedulerException;

    public TabularData getTriggersOfJob(String var1, String var2, String var3) throws SchedulerException;

    public Set<String> getPausedTriggerGroups(String var1) throws SchedulerException;

    public void pauseAllTriggers(String var1) throws SchedulerException;

    public void resumeAllTriggers(String var1) throws SchedulerException;

    public void pauseTriggerGroup(String var1, String var2) throws SchedulerException;

    public void resumeTriggerGroup(String var1, String var2) throws SchedulerException;

    public void pauseTrigger(String var1, String var2, String var3) throws SchedulerException;

    public void resumeTrigger(String var1, String var2, String var3) throws SchedulerException;

    public String[] getCalendarNames(String var1) throws SchedulerException;

    public void deleteCalendar(String var1, String var2) throws SchedulerException;

    public void setSampledStatisticsEnabled(boolean var1);

    public boolean isSampledStatisticsEnabled();
}

