/*
 * Decompiled with CFR 0.152.
 */
package adams.ml;

public class BaseData {
    protected Object m_data;

    public static boolean isNumeric(Object o) {
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            try {
                Double.parseDouble((String)o);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isString(Object o) {
        return o instanceof String;
    }

    public static boolean isArray(Object o) {
        return o.getClass().isArray();
    }

    public static boolean isBoolean(Object o) {
        return o instanceof Boolean;
    }

    public BaseData(Object o) {
        this.m_data = o;
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public Object getData(Type type) {
        return this.m_data;
    }

    public void setData(Object data, Type type) {
        this.m_data = data;
    }

    public static Type getType(Object data) {
        if (BaseData.isNumeric(data)) {
            return Type.NUMERIC;
        }
        if (BaseData.isArray(data)) {
            return Type.ARRAY;
        }
        if (BaseData.isBoolean(data)) {
            return Type.BOOLEAN;
        }
        if (BaseData.isString(data)) {
            return Type.STRING;
        }
        return null;
    }

    public static boolean typeEquals(Object data, Type typ) {
        int o2;
        Type nt = BaseData.getType(data);
        int o1 = nt.ordinal();
        return o1 == (o2 = typ.ordinal());
    }

    public boolean isNumeric() {
        return BaseData.isNumeric(this.m_data);
    }

    public boolean isArray() {
        return BaseData.isArray(this.m_data);
    }

    public boolean isString() {
        return BaseData.isString(this.m_data);
    }

    public static enum Type {
        NUMERIC,
        STRING,
        BOOLEAN,
        ARRAY;

    }
}

