/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.EnumItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMeta<T extends EnumItem> {
    private final Class enumClazz;
    private final List<T> items = new ArrayList<T>();
    private T enumDefault = null;

    public EnumMeta(Class enumClazz) {
        this.enumClazz = enumClazz;
    }

    protected void addItem(T item) {
        this.items.add(item);
    }

    public T getDefault() {
        return this.enumDefault;
    }

    public Class getEnumClazz() {
        return this.enumClazz;
    }

    public T getItem(String id) {
        if (id == null) {
            return null;
        }
        for (EnumItem element : this.items) {
            if (!element.getId().equals(id)) continue;
            return (T)element;
        }
        return null;
    }

    public T getItemOrDefault(String id) {
        T item = this.getItem(id);
        if (item == null) {
            item = this.getDefault();
        }
        return item;
    }

    public T[] getItems() {
        return this.items.toArray(new EnumItem[this.items.size()]);
    }

    public T getMax() {
        EnumItem max = null;
        for (EnumItem element : this.items) {
            if (max != null && element.getWeight() <= max.getWeight()) continue;
            max = element;
        }
        return (T)max;
    }

    public T getMin() {
        EnumItem min = null;
        for (EnumItem element : this.items) {
            if (min != null && element.getWeight() >= min.getWeight()) continue;
            min = element;
        }
        return (T)min;
    }

    protected void setDefault(T item) {
        this.enumDefault = item;
    }
}

