/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.logging.SimpleFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class MemoryLogHandler
extends Handler
implements INotificationSupport {
    private static final int DEFAULT_SIZE = 1000;
    private int size;
    private String id;
    private LogRecord[] buffer;
    private int start;
    private int count;
    private EventDispatcher dispatcher = new EventDispatcher(this);

    public MemoryLogHandler() {
        this.init();
    }

    public MemoryLogHandler(String id, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.id = id;
        this.init();
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    public synchronized void clear() {
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
        this.triggerChanged(null, null, null);
    }

    public void close() throws SecurityException {
        this.buffer = null;
        this.setLevel(Level.OFF);
    }

    public void flush() {
    }

    public String getId() {
        return this.id;
    }

    public synchronized LogRecord[] getLogRecords() {
        LogRecord[] result = new LogRecord[this.count];
        System.arraycopy(this.buffer, this.start, result, 0, this.count);
        return result;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public String getString() {
        StringBuilder sb = new StringBuilder();
        LogRecord[] records = this.getLogRecords();
        int i = 0;
        while (i < records.length) {
            LogRecord record = records[i];
            try {
                sb.append(this.getFormatter().format(record));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return sb.toString();
    }

    private void init() {
        this.setFormatter(new SimpleFormatter());
        this.size = 1000;
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = record;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
        }
        this.triggerChanged(null, null, record);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public void setId(String id) {
        this.id = id;
    }

    public synchronized void setSize(int size) {
        this.size = size;
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent(this, attribute, oldValue, newValue);
        this.triggerEvent(event);
    }

    protected void triggerEvent(Event event) {
        try {
            this.dispatcher.triggerEvent(event);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

