/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;

public class BufferedRandomAccess
extends AbstractRandomAccess {
    private static int DEFAULT_BUFFER_SIZE = 4096;
    private byte[] bytes;
    private long bytesOffset = 0L;
    private int count = 0;
    private int localOffset = 0;
    private IRandomAccess randomAccess;
    private long totalOffset = 0L;
    private boolean closed = false;
    private long length;
    private boolean bufferChanged = false;

    public BufferedRandomAccess(IRandomAccess randomAccess) throws IOException {
        this(randomAccess, DEFAULT_BUFFER_SIZE);
    }

    public BufferedRandomAccess(IRandomAccess randomAccess, int bufferSize) throws IOException {
        this.randomAccess = randomAccess;
        this.bytes = new byte[bufferSize];
        this.length = randomAccess.getLength();
    }

    protected int basicRead(byte[] buffer, int start, int numBytes) throws IOException {
        int avail;
        if (this.localOffset >= this.count) {
            if (numBytes >= this.bytes.length) {
                this.flushBuffer();
                this.randomAccess.seek(this.totalOffset);
                int readBytes = this.randomAccess.read(buffer, start, numBytes);
                if (readBytes > 0) {
                    this.totalOffset += (long)readBytes;
                    this.localOffset = this.count;
                }
                return readBytes;
            }
            this.fillBuffer();
            if (this.localOffset >= this.count) {
                return -1;
            }
        }
        int cnt = (avail = this.count - this.localOffset) < numBytes ? avail : numBytes;
        System.arraycopy(this.bytes, this.localOffset, buffer, start, cnt);
        this.localOffset += cnt;
        this.totalOffset += (long)cnt;
        return cnt;
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.flushBuffer();
        this.randomAccess.close();
        this.setClosed(true);
    }

    protected void fillBuffer() throws IOException {
        this.flushBuffer();
        this.randomAccess.seek(this.totalOffset);
        this.count = this.randomAccess.read(this.bytes, 0, this.bytes.length);
    }

    public void flush() throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        this.flushBuffer();
        this.randomAccess.flush();
    }

    protected void flushBuffer() throws IOException {
        if (this.bufferChanged && this.count > 0) {
            this.randomAccess.seek(this.bytesOffset);
            this.randomAccess.write(this.bytes, 0, this.count);
        }
        this.bytesOffset = this.totalOffset;
        this.localOffset = 0;
        this.count = 0;
        this.bufferChanged = false;
    }

    public long getLength() throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        return this.length;
    }

    public long getOffset() throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        return this.totalOffset;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    public boolean isReadOnly() {
        return this.randomAccess.isReadOnly();
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("random access closed");
        }
        if (this.localOffset >= this.count) {
            this.fillBuffer();
            if (this.localOffset >= this.count) {
                return -1;
            }
        }
        ++this.totalOffset;
        return this.bytes[this.localOffset++] & 0xFF;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int start, int numBytes) throws IOException {
        if (this.closed) {
            throw new IOException("random access closed");
        }
        if (numBytes == 0) {
            return 0;
        }
        int totalByteCount = 0;
        while (totalByteCount < numBytes) {
            int byteCount = this.basicRead(buffer, start + totalByteCount, numBytes - totalByteCount);
            if (byteCount <= 0) break;
            totalByteCount += byteCount;
        }
        if (totalByteCount == 0) {
            return -1;
        }
        return totalByteCount;
    }

    public void seek(long offset) throws IOException {
        if (this.closed) {
            throw new IOException("random access closed");
        }
        this.totalOffset = offset;
        long newLocalOffset = this.totalOffset - this.bytesOffset;
        if (newLocalOffset < 0L || newLocalOffset >= (long)this.count) {
            this.flushBuffer();
        } else {
            this.localOffset = (int)newLocalOffset;
        }
    }

    public void seekBy(long delta) throws IOException {
        if (this.closed) {
            throw new IOException("random access closed");
        }
        this.totalOffset += delta;
        long newLocalOffset = (long)this.localOffset + delta;
        if (newLocalOffset < 0L || newLocalOffset >= (long)this.count) {
            this.flushBuffer();
        } else {
            this.localOffset = (int)newLocalOffset;
        }
    }

    protected void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void setLength(long newLength) throws IOException {
        if (this.closed) {
            throw new IOException("random access closed");
        }
        if (newLength < this.bytesOffset + (long)this.bytes.length) {
            this.flushBuffer();
        }
        if (newLength < this.totalOffset) {
            this.totalOffset = newLength;
            this.bytesOffset = newLength;
        }
        this.length = newLength;
        this.randomAccess.setLength(newLength);
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int start, int numBytes) throws IOException {
        if (this.closed) {
            throw new IOException("random access closed");
        }
        if (numBytes >= this.bytes.length) {
            this.flushBuffer();
            this.randomAccess.seek(this.totalOffset);
            this.randomAccess.write(buffer, start, numBytes);
            this.totalOffset += (long)numBytes;
            this.bytesOffset = this.totalOffset;
            if (this.totalOffset > this.length) {
                this.length = this.totalOffset;
            }
            return;
        }
        if (numBytes > this.bytes.length - this.localOffset) {
            this.flushBuffer();
        }
        System.arraycopy(buffer, start, this.bytes, this.localOffset, numBytes);
        this.bufferChanged = true;
        this.totalOffset += (long)numBytes;
        this.localOffset += numBytes;
        if (this.totalOffset > this.length) {
            this.length = this.totalOffset;
        }
        if (this.localOffset >= this.count) {
            this.count = this.localOffset;
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("random access closed");
        }
        if (this.localOffset >= this.bytes.length) {
            this.flushBuffer();
        }
        this.bufferChanged = true;
        if (this.localOffset == this.count) {
            ++this.count;
        }
        ++this.totalOffset;
        if (this.totalOffset > this.length) {
            this.length = this.totalOffset;
        }
        this.bytes[this.localOffset++] = (byte)b;
    }
}

