/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.font.CIDFont;
import de.intarsys.pdf.font.CIDToGIDMap;

public class CIDFontType2
extends CIDFont {
    public static final MetaClass META = new MetaClass((Class)MetaClass.class.getDeclaringClass());
    public static final COSName DK_CIDToGIDMap = COSName.constant("CIDToGIDMap");
    private byte[] mappingTable;

    public CIDFontType2(COSObject object) {
        super(object);
    }

    public COSObject cosGetCIDToGIDMap() {
        return this.cosGetField(DK_CIDToGIDMap);
    }

    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_CIDFontType2;
    }

    public String getFontType() {
        return "TrueType";
    }

    public int getGlyphIndex(int cid) {
        int result;
        if (this.mappingTable == null) {
            COSObject map = this.cosGetCIDToGIDMap();
            if (map.isNull() || map instanceof COSName) {
                return cid;
            }
            this.mappingTable = ((COSStream)map).getDecodedBytes();
        }
        int index = cid << 1;
        try {
            result = this.mappingTable[index] & 0xFF;
            result = (result << 8) + (this.mappingTable[index + 1] & 0xFF);
        }
        catch (RuntimeException e) {
            return 0;
        }
        return result;
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(DK_CIDToGIDMap, CIDToGIDMap.CN_Identity);
    }

    public static class MetaClass
    extends CIDFont.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }
    }
}

