/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.postscript;

import de.intarsys.pdf.postscript.IOperator;
import de.intarsys.pdf.postscript.PSArray;
import de.intarsys.pdf.postscript.PSName;
import de.intarsys.pdf.postscript.PSPrimitiveObject;
import de.intarsys.pdf.postscript.ParseException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class Handler {
    private PSArray procedure;
    private Stack stack = new Stack();

    public Object get(int index) {
        return this.stack.get(index);
    }

    public Object peek() {
        return this.stack.peek();
    }

    public Object pop() {
        return this.stack.pop();
    }

    public List popResult() {
        ArrayList result = new ArrayList(this.stack.size());
        Iterator iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        this.stack.removeAllElements();
        return result;
    }

    public void processEndArray() {
        throw new UnsupportedOperationException();
    }

    public void processEndProcedure() {
        this.stack.push(this.procedure);
        this.procedure = null;
    }

    public void processIdentifier(String string) throws ParseException {
        IOperator operator;
        Class<?> clazz;
        if (this.procedure != null) {
            this.procedure.add(new PSName(string));
            return;
        }
        String name = MessageFormat.format("de.intarsys.pdf.postscript.Operator_{0}", string);
        try {
            clazz = Class.forName(name);
        }
        catch (Exception ex) {
            throw new ParseException(ex);
        }
        try {
            operator = (IOperator)clazz.getField("Instance").get(null);
        }
        catch (Exception ex) {
            throw new ParseException(ex);
        }
        operator.execute(this);
    }

    public void processImmediateIdentifier(String string) {
        throw new UnsupportedOperationException();
    }

    public void processKeyIdentifier(String string) {
        throw new UnsupportedOperationException();
    }

    public void processLiteral(double d) {
        if (this.procedure != null) {
            this.procedure.add(new PSPrimitiveObject(d));
            return;
        }
        this.stack.push(d);
    }

    public void processLiteral(int i) {
        if (this.procedure != null) {
            this.procedure.add(new PSPrimitiveObject(i));
            return;
        }
        this.stack.push(i);
    }

    public void processLiteral(Object object) {
        if (this.procedure != null) {
            this.procedure.add(new PSPrimitiveObject(object));
            return;
        }
        this.stack.push(object);
    }

    public void processStartArray() {
        throw new UnsupportedOperationException();
    }

    public void processStartProcedure() {
        this.procedure = new PSArray();
    }

    public void push(Object value) {
        this.stack.push(value);
    }

    public void pushArgs(List args) {
        this.stack.addAll(args);
    }

    public int size() {
        return this.stack.size();
    }
}

