/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.local.HillClimber;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RepeatedHillClimber
extends HillClimber {
    static final long serialVersionUID = -6574084564213041174L;
    int m_nRuns = 10;
    int m_nSeed = 1;
    Random m_random;

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        this.m_random = new Random(this.getSeed());
        double fCurrentScore = 0.0;
        for (int iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
            fCurrentScore += this.calcNodeScore(iAttribute);
        }
        double fBestScore = fCurrentScore;
        BayesNet bestBayesNet = new BayesNet();
        bestBayesNet.m_Instances = instances;
        bestBayesNet.initStructure();
        this.copyParentSets(bestBayesNet, bayesNet);
        for (int iRun = 0; iRun < this.m_nRuns; ++iRun) {
            this.generateRandomNet(bayesNet, instances);
            super.search(bayesNet, instances);
            fCurrentScore = 0.0;
            for (int iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
                fCurrentScore += this.calcNodeScore(iAttribute);
            }
            if (!(fCurrentScore > fBestScore)) continue;
            fBestScore = fCurrentScore;
            this.copyParentSets(bestBayesNet, bayesNet);
        }
        this.copyParentSets(bayesNet, bestBayesNet);
        bestBayesNet = null;
        this.m_Cache = null;
    }

    void generateRandomNet(BayesNet bayesNet, Instances instances) {
        int nNodes = instances.numAttributes();
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            ParentSet parentSet = bayesNet.getParentSet(iNode);
            while (parentSet.getNrOfParents() > 0) {
                parentSet.deleteLastParent(instances);
            }
        }
        if (this.getInitAsNaiveBayes()) {
            int iClass = instances.classIndex();
            for (int iNode = 0; iNode < nNodes; ++iNode) {
                if (iNode == iClass) continue;
                bayesNet.getParentSet(iNode).addParent(iClass, instances);
            }
        }
        int nNrOfAttempts = this.m_random.nextInt(nNodes * nNodes);
        for (int iAttempt = 0; iAttempt < nNrOfAttempts; ++iAttempt) {
            int iTail = this.m_random.nextInt(nNodes);
            int iHead = this.m_random.nextInt(nNodes);
            if (bayesNet.getParentSet(iHead).getNrOfParents() >= this.getMaxNrOfParents() || !this.addArcMakesSense(bayesNet, instances, iHead, iTail)) continue;
            bayesNet.getParentSet(iHead).addParent(iTail, instances);
        }
    }

    void copyParentSets(BayesNet dest, BayesNet source) {
        int nNodes = source.getNrOfNodes();
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            dest.getParentSet(iNode).copy(source.getParentSet(iNode));
        }
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int nRuns) {
        this.m_nRuns = nRuns;
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int nSeed) {
        this.m_nSeed = nSeed;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        newVector.addElement(new Option("\tRandom number seed", "A", 1, "-A <seed>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String sSeed;
        String sRuns = Utils.getOption('U', options);
        if (sRuns.length() != 0) {
            this.setRuns(Integer.parseInt(sRuns));
        }
        if ((sSeed = Utils.getOption('A', options)).length() != 0) {
            this.setSeed(Integer.parseInt(sSeed));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[7 + superOptions.length];
        int current = 0;
        options[current++] = "-U";
        options[current++] = "" + this.getRuns();
        options[current++] = "-A";
        options[current++] = "" + this.getSeed();
        for (int iOption = 0; iOption < superOptions.length; ++iOption) {
            options[current++] = superOptions[iOption];
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm repeatedly uses hill climbing starting with a randomly generated network structure and return the best structure of the various runs.";
    }

    public String runsTipText() {
        return "Sets the number of times hill climbing is performed.";
    }

    public String seedTipText() {
        return "Initialization value for random number generator. Setting the seed allows replicability of experiments.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

