/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

class ByteVector {
    private byte[] data;
    private int size;

    public ByteVector() {
        this.data = new byte[10];
        this.size = 0;
    }

    public ByteVector(int initialSize) {
        this.data = new byte[initialSize];
        this.size = 0;
    }

    public ByteVector(byte[] byteBuffer) {
        this.data = byteBuffer;
        this.size = 0;
    }

    public void add(byte x) {
        if (this.size >= this.data.length) {
            this.doubleCapacity();
            this.add(x);
        } else {
            this.data[this.size++] = x;
        }
    }

    public int size() {
        return this.size;
    }

    public void add(byte[] array) {
        int length = array.length;
        while (this.data.length - this.size < length) {
            this.doubleCapacity();
        }
        System.arraycopy(array, 0, this.data, this.size, length);
        this.size += length;
    }

    void doubleCapacity() {
        byte[] tmp = new byte[this.data.length * 2 + 1];
        System.arraycopy(this.data, 0, tmp, 0, this.data.length);
        this.data = tmp;
    }

    public void clear() {
        this.size = 0;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.data, 0, bytes, 0, this.size);
        return bytes;
    }
}

