/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.office;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jopendocument.model.number.NumberNumberStyle;
import org.jopendocument.model.style.StylePageLayout;
import org.jopendocument.model.style.StyleStyle;

public class OfficeAutomaticStyles {
    private final Map<String, StyleStyle> cellStyles = new HashMap<String, StyleStyle>();
    private final Map<String, NumberNumberStyle> numberStyles = new HashMap<String, NumberNumberStyle>();
    private final Map<String, StylePageLayout> pagesLayouts = new HashMap<String, StylePageLayout>();
    private final List<StyleStyle> styles = new Vector<StyleStyle>();
    private final Map<String, StyleStyle> stylesMap = new HashMap<String, StyleStyle>();
    private final Map<String, StyleStyle> tableStyles = new HashMap<String, StyleStyle>();

    public void addPageLayout(StylePageLayout stylePageLayout) {
        this.pagesLayouts.put(stylePageLayout.getStyleName(), stylePageLayout);
    }

    public void addStyle(StyleStyle styleStyle) {
        this.stylesMap.put(styleStyle.getStyleName(), styleStyle);
        this.styles.add(styleStyle);
    }

    public StyleStyle getCellStyle(String string) {
        StyleStyle styleStyle = this.cellStyles.get(string);
        if (styleStyle == null) {
            styleStyle = this.getStyle(string, "table-cell");
            this.cellStyles.put(string, styleStyle);
        }
        return styleStyle;
    }

    public StyleStyle getColumnStyle(String string) {
        return this.getStyle(string, "table-column");
    }

    public StyleStyle getRowStyle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The style name cannot be null");
        }
        return this.getStyle(string, "table-row");
    }

    private StyleStyle getStyle(String string, String string2) {
        StyleStyle styleStyle = this.stylesMap.get(string);
        if (styleStyle == null) {
            Set<String> set = this.stylesMap.keySet();
            System.err.println(this.styles);
            for (String string3 : set) {
                System.err.println("Key:" + string3);
            }
            throw new IllegalArgumentException("Unable to find Style name:" + string + " type:" + string2);
        }
        return styleStyle;
    }

    public StylePageLayout getStylePageLayoutFromStyleName(String string) {
        return this.pagesLayouts.get(string);
    }

    public List<StyleStyle> getStyles() {
        return this.styles;
    }

    public StyleStyle getTableStyle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null style name");
        }
        StyleStyle styleStyle = this.tableStyles.get(string);
        if (styleStyle == null) {
            styleStyle = this.getStyle(string, "table");
            this.tableStyles.put(string, styleStyle);
        }
        return styleStyle;
    }

    public StyleStyle getTextStyle(String string) {
        return this.getStyle(string, "text");
    }

    public String toString() {
        return "OfficeAutomaticStyles";
    }
}

