/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class ContentSummary
implements Writable {
    private long length;
    private long fileCount;
    private long directoryCount;
    private long quota;
    private long spaceConsumed;
    private long spaceQuota;
    private static final String STRING_FORMAT = "%12d %12d %18d ";
    private static final String QUOTA_STRING_FORMAT = "%12s %15s ";
    private static final String SPACE_QUOTA_STRING_FORMAT = "%15s %15s ";
    private static final String HEADER = String.format("%12d %12d %18d ".replace('d', 's'), "directories", "files", "bytes");
    private static final String QUOTA_HEADER = String.format("%12s %15s %15s %15s ", "quota", "remaining quota", "space quota", "reamaining quota") + HEADER;

    public ContentSummary() {
    }

    public ContentSummary(long length, long fileCount, long directoryCount) {
        this(length, fileCount, directoryCount, -1L, length, -1L);
    }

    public ContentSummary(long length, long fileCount, long directoryCount, long quota, long spaceConsumed, long spaceQuota) {
        this.length = length;
        this.fileCount = fileCount;
        this.directoryCount = directoryCount;
        this.quota = quota;
        this.spaceConsumed = spaceConsumed;
        this.spaceQuota = spaceQuota;
    }

    public long getLength() {
        return this.length;
    }

    public long getDirectoryCount() {
        return this.directoryCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getQuota() {
        return this.quota;
    }

    public long getSpaceConsumed() {
        return this.spaceConsumed;
    }

    public long getSpaceQuota() {
        return this.spaceQuota;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.length);
        out.writeLong(this.fileCount);
        out.writeLong(this.directoryCount);
        out.writeLong(this.quota);
        out.writeLong(this.spaceConsumed);
        out.writeLong(this.spaceQuota);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.length = in.readLong();
        this.fileCount = in.readLong();
        this.directoryCount = in.readLong();
        this.quota = in.readLong();
        this.spaceConsumed = in.readLong();
        this.spaceQuota = in.readLong();
    }

    public static String getHeader(boolean qOption) {
        return qOption ? QUOTA_HEADER : HEADER;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean qOption) {
        String prefix = "";
        if (qOption) {
            String quotaStr = "none";
            String quotaRem = "inf";
            String spaceQuotaStr = "none";
            String spaceQuotaRem = "inf";
            if (this.quota > 0L) {
                quotaStr = Long.toString(this.quota);
                quotaRem = Long.toString(this.quota - (this.directoryCount + this.fileCount));
            }
            if (this.spaceQuota > 0L) {
                spaceQuotaStr = Long.toString(this.spaceQuota);
                spaceQuotaRem = Long.toString(this.spaceQuota - this.spaceConsumed);
            }
            prefix = String.format("%12s %15s %15s %15s ", quotaStr, quotaRem, spaceQuotaStr, spaceQuotaRem);
        }
        return prefix + String.format(STRING_FORMAT, this.directoryCount, this.fileCount, this.length);
    }
}

