/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.statistics.StatUtils;
import adams.flow.container.WekaClusteringContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractProcessWekaInstanceWithModel;
import moa.clusterers.Clusterer;
import weka.core.Instance;

public class MOAClustering
extends AbstractProcessWekaInstanceWithModel<Clusterer> {
    private static final long serialVersionUID = 8362932772732931480L;
    protected boolean m_UpdateModel;

    public String globalInfo() {
        return "Uses a serialized MOA model to cluster data being passed through.\nThe model can also be obtained from a global actor, if the model file is pointing to a directory.\nOptionally, the model can be updated with data being passed through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("update-model", "updateModel", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_Model = null;
    }

    public void setUpdateModel(boolean value) {
        this.m_UpdateModel = value;
        this.reset();
    }

    public boolean getUpdateModel() {
        return this.m_UpdateModel;
    }

    public String updateModelTipText() {
        return "Whether to update the model with the Instance after making the prediction.";
    }

    public Class[] generates() {
        return new Class[]{WekaClusteringContainer.class};
    }

    protected Token processInstance(Instance inst) throws Exception {
        double[] vote = ((Clusterer)this.m_Model).getVotesForInstance(inst);
        WekaClusteringContainer cont = new WekaClusteringContainer(inst, StatUtils.minIndex((double[])vote), vote);
        if (this.m_UpdateModel) {
            ((Clusterer)this.m_Model).trainOnInstance(inst);
        }
        Token result = new Token((Object)((WekaClusteringContainer)cont.getClone()));
        return result;
    }
}

