/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.ClassLocator;
import adams.core.Properties;
import adams.core.Utils;
import adams.env.Environment;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;

public class ClassLister {
    public static final String FILENAME = "ClassLister.props";
    public static final String BLACKLIST = "ClassLister.blacklist";
    protected Properties m_Packages;
    protected Properties m_Classes;
    protected static ClassLister m_Singleton;

    private ClassLister() {
        this.initialize();
    }

    private void initialize() {
        try {
            this.m_Packages = Environment.getInstance().read("class lister");
            this.m_Classes = new Properties();
            Properties blacklist = Environment.getInstance().read("class lister blacklist");
            Enumeration<?> enm = this.m_Packages.propertyNames();
            while (enm.hasMoreElements()) {
                String superclass = (String)enm.nextElement();
                String[] packages = this.m_Packages.getString(superclass).replaceAll(" ", "").split(",");
                Vector<String> classes = ClassLocator.find(superclass, packages);
                if (blacklist.hasKey(superclass)) {
                    try {
                        String[] patterns;
                        for (String pattern : patterns = blacklist.getString(superclass).replaceAll(" ", "").split(",")) {
                            Pattern p = Pattern.compile(pattern);
                            int i = 0;
                            while (i < classes.size()) {
                                if (p.matcher(classes.get(i)).matches()) {
                                    classes.remove(i);
                                    continue;
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to blacklist classes for superclass '" + superclass + "':");
                        ex.printStackTrace();
                    }
                }
                this.m_Classes.setProperty(superclass, Utils.flatten(classes, ","));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to determine packages/classes:");
            e.printStackTrace();
            this.m_Packages = new Properties();
        }
    }

    public String[] getClassnames(Class superclass) {
        return this.getClassnames(superclass.getName());
    }

    public String[] getClassnames(String superclass) {
        String classes = this.m_Classes.getString(superclass);
        if (classes == null || classes.length() == 0) {
            return new String[0];
        }
        return classes.split(",");
    }

    public Properties getClasses() {
        return this.m_Classes;
    }

    public String[] getPackages(Class superclass) {
        return this.getPackages(superclass.getName());
    }

    public String[] getPackages(String superclass) {
        String packages = this.m_Packages.getString(superclass);
        if (packages == null || packages.length() == 0) {
            return new String[0];
        }
        return packages.split(",");
    }

    public Properties getPackages() {
        return this.m_Packages;
    }

    public String toString() {
        return this.m_Classes.toString();
    }

    public static synchronized ClassLister getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ClassLister();
        }
        return m_Singleton;
    }

    public static void main(String[] args) {
        System.out.println(new ClassLister());
    }
}

