/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TechnicalInformation {
    protected static final String MISSING_ID = "missing_id";
    protected Type m_Type = null;
    protected String m_ID = "";
    protected Hashtable m_Values = new Hashtable();
    protected Vector m_Additional = new Vector();

    public TechnicalInformation(Type type) {
        this(type, "");
    }

    public TechnicalInformation(Type type, String id) {
        this.m_Type = type;
        this.m_ID = id;
    }

    public Type getType() {
        return this.m_Type;
    }

    protected String[] getAuthors() {
        return this.getValue(Field.AUTHOR).split(" and ");
    }

    protected String generateID() {
        String result = this.m_ID;
        if (result.length() == 0 && this.exists(Field.AUTHOR) && this.exists(Field.YEAR)) {
            String[] authors = this.getAuthors();
            if (authors[0].indexOf(",") > -1) {
                String[] parts = authors[0].split(",");
                result = parts[0];
            } else {
                String[] parts = authors[0].split(" ");
                result = parts.length == 1 ? parts[0] : parts[parts.length - 1];
            }
            result = result + this.getValue(Field.YEAR);
            result = result.replaceAll(" ", "");
        }
        if (result.length() == 0) {
            result = MISSING_ID;
        }
        return result;
    }

    public String getID() {
        return this.generateID();
    }

    public void setValue(Field field, String value) {
        this.m_Values.put(field, value);
    }

    public String getValue(Field field) {
        if (this.m_Values.containsKey((Object)field)) {
            return (String)this.m_Values.get((Object)field);
        }
        return "";
    }

    public boolean exists(Field field) {
        return this.m_Values.containsKey((Object)field) && ((String)this.m_Values.get((Object)field)).length() != 0;
    }

    public Enumeration fields() {
        return this.m_Values.keys();
    }

    public boolean hasAdditional() {
        return this.m_Additional.size() > 0;
    }

    public Enumeration additional() {
        return this.m_Additional.elements();
    }

    public void add(TechnicalInformation value) {
        if (value == this) {
            throw new IllegalArgumentException("Can't add object to itself!");
        }
        this.m_Additional.add(value);
    }

    public TechnicalInformation add(Type type) {
        TechnicalInformation result = new TechnicalInformation(type);
        this.add(result);
        return result;
    }

    public String toString() {
        int i;
        String result = "";
        String[] authors = this.getAuthors();
        if (this.getType() == Type.BOOK) {
            for (i = 0; i < authors.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + authors[i];
            }
            result = this.exists(Field.YEAR) ? result + " (" + this.getValue(Field.YEAR) + ")." : result + ".";
            result = result + " " + this.getValue(Field.TITLE) + ".";
            result = result + " " + this.getValue(Field.PUBLISHER);
            if (this.exists(Field.ADDRESS)) {
                result = result + ", " + this.getValue(Field.ADDRESS);
            }
            result = result + ".";
        } else if (this.getType() == Type.ARTICLE) {
            for (i = 0; i < authors.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + authors[i];
            }
            result = this.exists(Field.YEAR) ? result + " (" + this.getValue(Field.YEAR) + ")." : result + ".";
            result = result + " " + this.getValue(Field.TITLE) + ".";
            if (this.exists(Field.JOURNAL)) {
                result = result + " " + this.getValue(Field.JOURNAL) + ".";
                if (this.exists(Field.VOLUME)) {
                    result = result + " " + this.getValue(Field.VOLUME);
                }
                if (this.exists(Field.NUMBER)) {
                    result = result + "(" + this.getValue(Field.NUMBER) + ")";
                }
                if (this.exists(Field.PAGES)) {
                    result = result + ":" + this.getValue(Field.PAGES);
                }
                result = result + ".";
            }
            if (this.exists(Field.URL)) {
                result = result + " URL " + this.getValue(Field.URL) + ".";
            }
        } else if (this.getType() == Type.CONFERENCE || this.getType() == Type.INPROCEEDINGS) {
            for (i = 0; i < authors.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + authors[i];
            }
            result = result + ": " + this.getValue(Field.TITLE) + ".";
            result = result + " In: " + this.getValue(Field.BOOKTITLE);
            if (this.exists(Field.ADDRESS)) {
                result = result + ", " + this.getValue(Field.ADDRESS);
            }
            if (this.exists(Field.PAGES)) {
                result = result + ", " + this.getValue(Field.PAGES);
            }
            result = this.exists(Field.YEAR) ? result + ", " + this.getValue(Field.YEAR) + "." : result + ".";
        } else if (this.getType() == Type.INCOLLECTION) {
            for (i = 0; i < authors.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + authors[i];
            }
            result = result + ": " + this.getValue(Field.TITLE) + ".";
            result = result + " In ";
            if (this.exists(Field.EDITOR)) {
                result = result + this.getValue(Field.EDITOR) + ", editors, ";
            }
            result = result + this.getValue(Field.BOOKTITLE);
            if (this.exists(Field.ADDRESS)) {
                result = result + ", " + this.getValue(Field.ADDRESS);
            }
            if (this.exists(Field.PAGES)) {
                result = result + ", " + this.getValue(Field.PAGES);
            }
            result = this.exists(Field.YEAR) ? result + ", " + this.getValue(Field.YEAR) + "." : result + ".";
        } else {
            for (i = 0; i < authors.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + authors[i];
            }
            result = this.exists(Field.YEAR) ? result + " (" + this.getValue(Field.YEAR) + ")." : result + ".";
            result = result + " " + this.getValue(Field.TITLE) + ".";
            if (this.exists(Field.ADDRESS)) {
                result = result + " " + this.getValue(Field.ADDRESS) + ".";
            }
            if (this.exists(Field.URL)) {
                result = result + " URL " + this.getValue(Field.URL) + ".";
            }
        }
        Enumeration enm = this.additional();
        while (enm.hasMoreElements()) {
            result = result + "\n\n" + enm.nextElement().toString();
        }
        return result;
    }

    public String toBibTex() {
        String result = "@" + (Object)((Object)this.getType()) + "{" + this.getID() + "";
        Vector list = new Vector();
        Enumeration enm = this.fields();
        while (enm.hasMoreElements()) {
            list.add(enm.nextElement());
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            Field field = (Field)((Object)list.get(i));
            if (!this.exists(field)) continue;
            String value = this.getValue(field);
            value = value.replaceAll("\\~", "\\\\~");
            result = result + ",\n   " + (Object)((Object)field) + " = {" + value + "}";
        }
        result = result + "\n}";
        enm = this.additional();
        while (enm.hasMoreElements()) {
            result = result + "\n\n" + ((TechnicalInformation)enm.nextElement()).toBibTex();
        }
        return result;
    }

    public static enum Field {
        ADDRESS("address", "Usually the address of the publisher or other type of institution. For major publishing houses, van Leunen recommends omitting the information entirely. For small publishers, on the other hand, you can help the reader by giving the complete address."),
        ANNOTE("annote", "An annotation. It is not used by the standard bibliography styles, but may be used by others that produce an annotated bibliography."),
        AUTHOR("author", "The name(s) of the author(s), in the format described in the LaTeX book."),
        BOOKTITLE("booktitle", "Title of a book, part of which is being cited. See the LaTeX book for how to type titles. For book entries, use the title field instead."),
        CHAPTER("chapter", "A chapter (or section or whatever) number."),
        CROSSREF("crossref", "The database key of the entry being cross referenced. Any fields that are missing from the current record are inherited from the field being cross referenced."),
        EDITION("edition", "The edition of a book---for example, ``Second''. This should be an ordinal, and should have the first letter capitalized, as shown here; the standard styles convert to lower case when necessary."),
        EDITOR("editor", "Name(s) of editor(s), typed as indicated in the LaTeX book. If there is also an author field, then the editor field gives the editor of the book or collection in which the reference appears."),
        HOWPUBLISHED("howpublished", "How something strange has been published. The first word should be capitalized."),
        INSTITUTION("institution", "The sponsoring institution of a technical report."),
        JOURNAL("journal", "A journal name. Abbreviations are provided for many journals."),
        KEY("key", "Used for alphabetizing, cross referencing, and creating a label when the ``author'' information is missing. This field should not be confused with the key that appears in the cite command and at the beginning of the database entry."),
        MONTH("month", "The month in which the work was published or, for an unpublished work, in which it was written. You should use the standard three-letter abbreviation, as described in Appendix B.1.3 of the LaTeX book."),
        NOTE("note", "Any additional information that can help the reader. The first word should be capitalized."),
        NUMBER("number", "The number of a journal, magazine, technical report, or of a work in a series. An issue of a journal or magazine is usually identified by its volume and number; the organization that issues a technical report usually gives it a number; and sometimes books are given numbers in a named series."),
        ORGANIZATION("organization", "The organization that sponsors a conference or that publishes a manual."),
        PAGES("pages", "One or more page numbers or range of numbers, such as 42--111 or 7,41,73--97 or 43+ (the `+' in this last example indicates pages following that don't form a simple range). To make it easier to maintain Scribe-compatible databases, the standard styles convert a single dash (as in 7-33) to the double dash used in TeX to denote number ranges (as in 7--33)."),
        PUBLISHER("publisher", "The publisher's name."),
        SCHOOL("school", "The name of the school where a thesis was written."),
        SERIES("series", "The name of a series or set of books. When citing an entire book, the the title field gives its title and an optional series field gives the name of a series or multi-volume set in which the book is published."),
        TITLE("title", "The work's title, typed as explained in the LaTeX book."),
        TYPE("type", "The type of a technical report---for example, ``Research Note''."),
        VOLUME("volume", "The volume of a journal or multi-volume book."),
        YEAR("year", "The year of publication or, for an unpublished work, the year it was written. Generally it should consist of four numerals, such as 1984, although the standard styles can handle any year whose last four nonpunctuation characters are numerals, such as `\\hbox{(about 1984)}'."),
        AFFILIATION("affiliation", "The authors affiliation."),
        ABSTRACT("abstract", "An abstract of the work."),
        CONTENTS("contents", "A Table of Contents "),
        COPYRIGHT("copyright", "Copyright information."),
        ISBN("ISBN", "The International Standard Book Number."),
        ISSN("ISSN", "The International Standard Serial Number. Used to identify a journal."),
        KEYWORDS("keywords", "Key words used for searching or possibly for annotation."),
        LANGUAGE("language", "The language the document is in."),
        LOCATION("location", "A location associated with the entry, such as the city in which a conference took place."),
        LCCN("LCCN", "The Library of Congress Call Number. I've also seen this as lib-congress."),
        MRNUMBER("mrnumber", "The Mathematical Reviews number."),
        PRICE("price", "The price of the document."),
        SIZE("size", "The physical dimensions of a work."),
        URL("URL", "The WWW Universal Resource Locator that points to the item being referenced. This often is used for technical reports to point to the ftp site where the postscript source of the report is located."),
        PS("PS", "A link to a postscript file."),
        PDF("PDF", "A link to a PDF file."),
        HTTP("HTTP", "A hyperlink to a resource.");

        protected String m_Display;
        protected String m_Comment;

        private Field(String display, String comment) {
            this.m_Display = display;
            this.m_Comment = comment;
        }

        public String getDisplay() {
            return this.m_Display;
        }

        public String getComment() {
            return this.m_Comment;
        }

        public String toString() {
            return this.m_Display;
        }
    }

    public static enum Type {
        ARTICLE("article", "An article from a journal or magazine."),
        BOOK("book", "A book with an explicit publisher."),
        BOOKLET("booklet", "A work that is printed and bound, but without a named publisher or sponsoring institution."),
        CONFERENCE("conference", "The same as inproceedings."),
        INBOOK("inbook", "A part of a book, which may be a chapter (or section or whatever) and/or a range of pages."),
        INCOLLECTION("incollection", "A part of a book having its own title."),
        INPROCEEDINGS("inproceedings", "An article in a conference proceedings."),
        MANUAL("manual", "Technical documentation."),
        MASTERSTHESIS("mastersthesis", "A Master's thesis."),
        MISC("misc", "Use this type when nothing else fits."),
        PHDTHESIS("phdthesis", "A PhD thesis."),
        PROCEEDINGS("proceedings", "The proceedings of a conference."),
        TECHREPORT("techreport", "A report published by a school or other institution, usually numbered within a series."),
        UNPUBLISHED("unpublished", "A document having an author and title, but not formally published.");

        protected String m_Display;
        protected String m_Comment;

        private Type(String display, String comment) {
            this.m_Display = display;
            this.m_Comment = comment;
        }

        public String getDisplay() {
            return this.m_Display;
        }

        public String getComment() {
            return this.m_Comment;
        }

        public String toString() {
            return this.m_Display;
        }
    }
}

