/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Utils;

public class HtmlUtils {
    public static String toHTML(String s) {
        String result = s;
        result = result.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("@", "&#64;");
        result = result.replaceAll("/", "&#47;");
        return result;
    }

    public static String toHTML(String s, boolean nbsp) {
        String result = HtmlUtils.toHTML(s);
        result = result.replace("\n", "<br>\n");
        if (nbsp) {
            String[] lines = result.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                boolean first = true;
                StringBuilder newLine = new StringBuilder();
                for (int n = 0; n < lines[i].length(); ++n) {
                    if (first) {
                        if (lines[i].charAt(n) == ' ') {
                            newLine.append("&#160;");
                            continue;
                        }
                        first = false;
                        newLine.append(lines[i].charAt(n));
                        continue;
                    }
                    newLine.append(lines[i].charAt(n));
                }
                lines[i] = newLine.toString();
            }
            result = Utils.flatten(lines, "\n");
        }
        return result;
    }

    public static String fromHTML(String s) {
        String result = s;
        result = result.replaceAll("&lt;", "<");
        result = result.replaceAll("&gt;", ">");
        result = result.replaceAll("&#64;", "@");
        result = result.replaceAll("&#47;", "/");
        result = result.replaceAll("&amp;", "&");
        return result;
    }
}

