/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class SimpleResultSet {
    private ResultSet m_rs = null;

    public SimpleResultSet(ResultSet rs) {
        this.m_rs = rs;
    }

    public boolean next() throws SQLException {
        if (this.m_rs == null) {
            return false;
        }
        boolean res = this.m_rs.next();
        if (!res) {
            this.close();
        }
        return res;
    }

    public void close() throws SQLException {
        if (this.m_rs != null) {
            Statement s = this.m_rs.getStatement();
            this.m_rs.close();
            if (s != null) {
                s.close();
                s = null;
            }
            this.m_rs = null;
        }
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.m_rs.getTimestamp(columnName);
    }

    public long getLong(String columnName) throws SQLException {
        return this.m_rs.getLong(columnName);
    }

    public int getInt(String columnName) throws SQLException {
        return this.m_rs.getInt(columnName);
    }

    public float getFloat(String columnName) throws SQLException {
        return this.m_rs.getFloat(columnName);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.m_rs.getDouble(columnName);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.m_rs.getBoolean(columnName);
    }

    public String getString(String columnName) throws SQLException {
        return this.m_rs.getString(columnName);
    }
}

