/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Placeholders;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.flow.transformer.AbstractStringOperation;

public class StringReplace
extends AbstractStringOperation {
    private static final long serialVersionUID = -1167336515862285272L;
    public static final String BACKUP_ACTUALREPLACE = "actual replace";
    protected BaseRegExp m_Find;
    protected String m_Replace;
    protected boolean m_ReplaceAll;
    protected boolean m_ReplaceContainsPlaceholder;
    protected boolean m_ReplaceContainsVariable;

    @Override
    public String globalInfo() {
        return "Performs a string replacement, using either String.replaceFirst(...) or String.replaceAll(...). Special characters like \\n \\r \\t and \\ need to be escaped properly. The input is expected to be escaped, i.e., the string \"\\t\" will get turned into the character '\\t'.\nIf the 'replace' string contains both, variables and placeholders, then first all variables are expanded and then the placeholders. This ensures that variables containing placeholders expand their placeholders as well. Not expanding placeholders will cause 'Illegal group reference' error messages.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("find", "find", new BaseRegExp("find"));
        this.m_OptionManager.add("replace", "replace", "");
        this.m_OptionManager.add("all", "replaceAll", false);
        this.m_OptionManager.add("placeholder", "replaceContainsPlaceholder", false);
        this.m_OptionManager.add("variable", "replaceContainsVariable", false);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("replace");
        String replace = variable != null ? variable : this.m_Replace;
        variable = this.getOptionManager().getVariableForProperty("find");
        String find = variable != null ? variable : this.m_Find.getValue();
        String result = replace.length() > 0 ? "replace " : "remove ";
        result = result + "'" + find + "'";
        if (replace.length() > 0) {
            result = result + " with '" + replace + "'";
        }
        return result;
    }

    public void setFind(BaseRegExp value) {
        this.m_Find = value;
        this.reset();
    }

    public BaseRegExp getFind() {
        return this.m_Find;
    }

    public String findTipText() {
        return "The string to find (a regular expression).";
    }

    public void setReplace(String value) {
        this.m_Replace = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getReplace() {
        return Utils.backQuoteChars(this.m_Replace);
    }

    public String replaceTipText() {
        return "The string to replace the occurrences with.";
    }

    public void setReplaceAll(boolean value) {
        this.m_ReplaceAll = value;
        this.reset();
    }

    public boolean getReplaceAll() {
        return this.m_ReplaceAll;
    }

    public String replaceAllTipText() {
        return "If set to true, then all occurrences will be replaced; otherwise only the first.";
    }

    public void setReplaceContainsPlaceholder(boolean value) {
        this.m_ReplaceContainsPlaceholder = value;
        this.reset();
    }

    public boolean getReplaceContainsPlaceholder() {
        return this.m_ReplaceContainsPlaceholder;
    }

    public String replaceContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the replacement string.";
    }

    public void setReplaceContainsVariable(boolean value) {
        this.m_ReplaceContainsVariable = value;
        this.reset();
    }

    public boolean getReplaceContainsVariable() {
        return this.m_ReplaceContainsVariable;
    }

    public String replaceContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the replacement string.";
    }

    @Override
    protected String process(String s) {
        String replace = this.m_Replace;
        if (this.m_ReplaceContainsVariable) {
            replace = this.getVariables().expand(replace);
        }
        if (this.m_ReplaceContainsPlaceholder) {
            replace = Placeholders.getSingleton().expand(replace).replace("\\", "/");
        }
        if (this.isDebugOn()) {
            this.debug("replacement string: " + replace);
        }
        if (this.m_ReplaceAll) {
            return s.replaceAll(this.m_Find.getValue(), replace);
        }
        return s.replaceFirst(this.m_Find.getValue(), replace);
    }
}

