/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractTemplate;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.template.DummyTransformer;
import java.util.Hashtable;

public class TemplateTransformer
extends AbstractTemplate
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = 2327297866200504943L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Feeds tokens into an actor generated from a template and broadcasts the generated output tokens.";
    }

    @Override
    protected AbstractActorTemplate getDefaultTemplate() {
        return new DummyTransformer();
    }

    @Override
    protected String setUpTemplate() {
        String result = super.setUpTemplate();
        if (result == null && !ActorUtils.isTransformer(this.m_Actor)) {
            result = "Template '" + this.m_Template + "' does not generate a transformer actor: " + this.m_Actor;
        }
        return result;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_INPUT, this.m_InputToken);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_InputToken = null;
    }

    @Override
    public Class[] accepts() {
        if (this.m_Actor != null) {
            return ((InputConsumer)((Object)this.m_Actor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    @Override
    public Class[] generates() {
        if (this.m_Actor != null) {
            return ((OutputProducer)((Object)this.m_Actor)).generates();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_Actor == null) {
            result = this.setUpTemplate();
        }
        if (result == null) {
            ((InputConsumer)((Object)this.m_Actor)).input(this.m_InputToken);
            result = this.m_Actor.execute();
        }
        return result;
    }

    @Override
    public Token output() {
        this.m_InputToken = null;
        return ((OutputProducer)((Object)this.m_Actor)).output();
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Actor != null && ((OutputProducer)((Object)this.m_Actor)).hasPendingOutput();
    }
}

