/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.io.FileUtils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class BufferHistoryPanel
extends AbstractNamedHistoryPanel<StringBuffer>
implements AbstractNamedHistoryPanel.FrameDisplaySupporter<StringBuffer> {
    private static final long serialVersionUID = 1704390033157269580L;
    protected Hashtable<String, BufferFrame> m_Frames;
    protected JTextArea m_TextArea;
    protected BaseFileChooser m_FileChooser;
    protected boolean m_CaretAtStart;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Frames = new Hashtable();
        this.m_TextArea = null;
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.setPromptOverwriteFile(true);
        this.m_FileChooser.addChoosableFileFilter(ExtensionFileFilter.getTextFileFilter());
        this.m_FileChooser.setDefaultExtension(ExtensionFileFilter.getTextFileFilter().getExtensions()[0]);
        this.m_CaretAtStart = false;
    }

    public void setTextArea(JTextArea value) {
        this.m_TextArea = value;
    }

    @Override
    protected void updateEntry(String name) {
        this.m_TextArea.setText("");
        if (name != null) {
            if (this.hasEntry(name)) {
                this.m_TextArea.setText(((StringBuffer)this.getEntry(name)).toString());
            }
            if (this.m_CaretAtStart) {
                this.m_TextArea.setCaretPosition(0);
            }
            if (this.hasFrame(name)) {
                this.showFrame(name);
            }
        }
    }

    @Override
    public boolean hasFrame(String name) {
        return this.m_Frames.containsKey(name);
    }

    public BufferFrame newFrame(String name) {
        BufferFrame result = new BufferFrame(this, name);
        this.m_Frames.put(name, result);
        return result;
    }

    public BufferFrame getFrame(String name) {
        return this.m_Frames.get(name);
    }

    @Override
    public void showFrame(String name) {
        BufferFrame frame;
        if (!this.hasFrame(name)) {
            frame = this.newFrame(name);
            frame.setLocationRelativeTo(this);
        } else {
            frame = this.getFrame(name);
        }
        frame.setVisible(true);
        frame.toFront();
    }

    @Override
    public void removeFrame(String name) {
        this.m_Frames.remove(name);
    }

    @Override
    public StringBuffer removeEntry(String name) {
        StringBuffer result = (StringBuffer)super.removeEntry(name);
        if (this.hasFrame(name)) {
            this.getFrame(name).setVisible(false);
        }
        return result;
    }

    @Override
    protected JPopupMenu createPopup(MouseEvent e) {
        JPopupMenu result = super.createPopup(e);
        final int[] indices = this.getSelectedIndices();
        result.addSeparator();
        JMenuItem menuitem = new JMenuItem("Save...");
        menuitem.setEnabled(indices.length == 1);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferHistoryPanel.this.saveEntry(BufferHistoryPanel.this.getEntryName(indices[0]));
            }
        });
        result.add(menuitem);
        return result;
    }

    protected void saveEntry(String name) {
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        FileUtils.writeToFile(this.m_FileChooser.getSelectedFile().getAbsolutePath(), ((StringBuffer)this.getEntry(name)).toString());
    }

    public void setCaretAtStart(boolean value) {
        this.m_CaretAtStart = value;
        if (this.getSelectedEntry() != null) {
            this.updateEntry(this.getSelectedEntry());
        }
    }

    public boolean isCaretAtStart() {
        return this.m_CaretAtStart;
    }

    public static class BufferFrame
    extends AbstractNamedHistoryPanel.AbstractHistoryEntryFrame<StringBuffer> {
        private static final long serialVersionUID = 2552148773749071235L;
        protected JTextArea m_TextArea;

        public BufferFrame(AbstractNamedHistoryPanel<StringBuffer> owner, String name) {
            super(owner, name);
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.getContentPane().setLayout(new BorderLayout());
            this.m_TextArea = new JTextArea();
            this.m_TextArea.setFont(new Font("monospaced", 0, 12));
            this.getContentPane().add((Component)new BaseScrollPane(this.m_TextArea), "Center");
        }

        @Override
        public void updateEntry() {
            StringBuffer buffer = (StringBuffer)this.getEntryOwner().getEntry(this.getEntryName());
            if (buffer != null) {
                this.m_TextArea.setText(buffer.toString());
            } else {
                this.m_TextArea.setText("");
            }
        }
    }
}

