/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.postprocessor;

import adams.core.VariableName;
import adams.flow.core.AbstractActor;
import adams.flow.processor.UpdateVariableName;
import adams.flow.transformer.SetVariable;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.flow.tree.postprocessor.AbstractEditPostProcessor;

public class VariableRenamed
extends AbstractEditPostProcessor {
    private static final long serialVersionUID = -8661419635908219055L;

    public String globalInfo() {
        return "Updates all references of the variable that was renamed.";
    }

    protected VariableName getVariableName(AbstractActor actor) {
        VariableName result = null;
        if (actor instanceof adams.flow.standalone.SetVariable) {
            result = ((adams.flow.standalone.SetVariable)actor).getVariableName();
        } else if (actor instanceof SetVariable) {
            result = ((SetVariable)actor).getVariableName();
        }
        return result;
    }

    @Override
    public boolean applies(AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        boolean result = false;
        VariableName oldName = this.getVariableName(oldActor);
        VariableName newName = this.getVariableName(newActor);
        if (oldName != null) {
            result = !oldName.equals(newName);
        }
        return result;
    }

    @Override
    public boolean postProcess(Tree tree, AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        boolean result = false;
        UpdateVariableName updater = new UpdateVariableName();
        updater.setOldName(this.getVariableName(oldActor).getValue());
        updater.setNewName(this.getVariableName(newActor).getValue());
        updater.process(tree.getActor());
        if (updater.isModified()) {
            result = true;
            tree.setModified(true);
            tree.setActor(updater.getModifiedActor());
            tree.notifyActorChangeListeners(new ActorChangeEvent(tree, new Node[0], ActorChangeEvent.Type.MODIFY_BULK));
            tree.refreshTabs();
        }
        return result;
    }
}

