/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.BaseText;
import adams.core.option.AbstractOption;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BaseTextEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected BaseTextArea m_TextValue;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseText)object).stringValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseText(Utils.unbackQuoteChars(str));
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return BaseTextEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return BaseTextEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + BaseTextEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : BaseTextEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        this.m_TextValue = new BaseTextArea(30, 60);
        panelAll.add((Component)new BaseScrollPane(this.m_TextValue), "Center");
        panelAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = BaseTextEditor.this.m_TextValue.getText();
                if (((BaseText)BaseTextEditor.this.getValue()).isValid(s) && !s.equals(((BaseObject)BaseTextEditor.this.getValue()).getValue())) {
                    BaseTextEditor.this.setValue(new BaseText(s));
                }
                BaseTextEditor.this.closeDialog();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseTextEditor.this.closeDialog();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    @Override
    protected void initForDisplay() {
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        this.m_TextValue.setToolTipText(((BaseObject)this.getValue()).getTipText());
    }
}

